/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj.support;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class SaajUtils {
    public static final int SAAJ_11 = 0;
    public static final int SAAJ_12 = 1;
    public static final int SAAJ_13 = 2;
    private static int saajVersion = 2;

    public static int getSaajVersion() {
        return saajVersion;
    }

    public static int getSaajVersion(SOAPMessage soapMessage) throws SOAPException {
        Assert.notNull((Object)soapMessage, (String)"'soapMessage' must not be null");
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        return SaajUtils.getSaajVersion((SOAPElement)soapEnvelope);
    }

    public static int getSaajVersion(SOAPElement soapElement) {
        return 2;
    }

    public static String getSaajVersionString() {
        return SaajUtils.getSaajVersionString(saajVersion);
    }

    private static String getSaajVersionString(int saajVersion) {
        if (saajVersion >= 2) {
            return "SAAJ 1.3";
        }
        if (saajVersion == 1) {
            return "SAAJ 1.2";
        }
        if (saajVersion == 0) {
            return "SAAJ 1.1";
        }
        return "";
    }

    public static Name toName(QName qName, SOAPElement resolveElement) throws SOAPException {
        String qNamePrefix = qName.getPrefix();
        SOAPEnvelope envelope = SaajUtils.getEnvelope(resolveElement);
        if (StringUtils.hasLength((String)qName.getNamespaceURI()) && StringUtils.hasLength((String)qNamePrefix)) {
            return envelope.createName(qName.getLocalPart(), qNamePrefix, qName.getNamespaceURI());
        }
        if (StringUtils.hasLength((String)qName.getNamespaceURI())) {
            Iterator prefixes = SaajUtils.getSaajVersion(resolveElement) == 0 ? resolveElement.getNamespacePrefixes() : resolveElement.getVisibleNamespacePrefixes();
            while (prefixes.hasNext()) {
                String prefix = (String)prefixes.next();
                if (!qName.getNamespaceURI().equals(resolveElement.getNamespaceURI(prefix))) continue;
                return envelope.createName(qName.getLocalPart(), prefix, qName.getNamespaceURI());
            }
            return envelope.createName(qName.getLocalPart(), "", qName.getNamespaceURI());
        }
        return envelope.createName(qName.getLocalPart());
    }

    public static QName toQName(Name name) {
        if (StringUtils.hasLength((String)name.getURI()) && StringUtils.hasLength((String)name.getPrefix())) {
            return new QName(name.getURI(), name.getLocalName(), name.getPrefix());
        }
        if (StringUtils.hasLength((String)name.getURI())) {
            return new QName(name.getURI(), name.getLocalName());
        }
        return new QName(name.getLocalName());
    }

    public static SOAPMessage loadMessage(Resource resource, MessageFactory messageFactory) throws SOAPException, IOException {
        try (InputStream is = resource.getInputStream();){
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            mimeHeaders.addHeader("Content-Length", Long.toString(resource.getFile().length()));
            SOAPMessage sOAPMessage = messageFactory.createMessage(mimeHeaders, is);
            return sOAPMessage;
        }
    }

    public static SOAPEnvelope getEnvelope(SOAPElement element) {
        Assert.notNull((Object)element, (String)"Element should not be null");
        do {
            if (!(element instanceof SOAPEnvelope)) continue;
            return (SOAPEnvelope)element;
        } while ((element = element.getParentElement()) != null);
        return null;
    }

    public static SOAPElement getFirstBodyElement(SOAPBody body) {
        Iterator iterator = body.getChildElements();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (!(child instanceof SOAPElement)) continue;
            return (SOAPElement)child;
        }
        return null;
    }
}

