/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.CollectionUtils;
import org.springframework.ws.soap.server.endpoint.AbstractSoapFaultDefinitionExceptionResolver;
import org.springframework.ws.soap.server.endpoint.SoapFaultDefinition;
import org.springframework.ws.soap.server.endpoint.SoapFaultDefinitionEditor;

public class SoapFaultMappingExceptionResolver
extends AbstractSoapFaultDefinitionExceptionResolver {
    private Map<String, String> exceptionMappings = new LinkedHashMap<String, String>();

    public void setExceptionMappings(Properties mappings) {
        for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            this.exceptionMappings.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    protected SoapFaultDefinition getFaultDefinition(Object endpoint, Exception ex) {
        if (!CollectionUtils.isEmpty(this.exceptionMappings)) {
            String definitionText = null;
            int deepest = Integer.MAX_VALUE;
            for (Map.Entry<String, String> exceptionMapping : this.exceptionMappings.entrySet()) {
                int depth = this.getDepth(exceptionMapping.getKey(), ex);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                definitionText = exceptionMapping.getValue();
            }
            if (definitionText != null) {
                SoapFaultDefinitionEditor editor = new SoapFaultDefinitionEditor();
                editor.setAsText(definitionText);
                return (SoapFaultDefinition)editor.getValue();
            }
        }
        return null;
    }

    protected int getDepth(String exceptionMapping, Exception ex) {
        return this.getDepth(exceptionMapping, ex.getClass(), 0);
    }

    private int getDepth(String exceptionMapping, Class<? extends Exception> exceptionClass, int depth) {
        if (exceptionClass.getName().contains(exceptionMapping)) {
            return depth;
        }
        if (exceptionClass.equals(Throwable.class)) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }
}

