/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.mapping;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.endpoint.mapping.AbstractMapBasedEndpointMapping;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInvocationChain;
import org.springframework.ws.soap.server.SoapEndpointMapping;

public class SoapActionEndpointMapping
extends AbstractMapBasedEndpointMapping
implements SoapEndpointMapping {
    private String[] actorsOrRoles;
    private boolean isUltimateReceiver = true;

    @Override
    public final void setActorOrRole(String actorOrRole) {
        Assert.notNull((Object)actorOrRole, (String)"actorOrRole must not be null");
        this.actorsOrRoles = new String[]{actorOrRole};
    }

    @Override
    public final void setActorsOrRoles(String[] actorsOrRoles) {
        Assert.notEmpty((Object[])actorsOrRoles, (String)"actorsOrRoles must not be empty");
        this.actorsOrRoles = actorsOrRoles;
    }

    @Override
    public final void setUltimateReceiver(boolean ultimateReceiver) {
        this.isUltimateReceiver = ultimateReceiver;
    }

    @Override
    protected final EndpointInvocationChain createEndpointInvocationChain(MessageContext messageContext, Object endpoint, EndpointInterceptor[] interceptors) {
        return new SoapEndpointInvocationChain(endpoint, interceptors, this.actorsOrRoles, this.isUltimateReceiver);
    }

    @Override
    protected String getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        WebServiceMessage webServiceMessage = messageContext.getRequest();
        if (webServiceMessage instanceof SoapMessage) {
            SoapMessage request = (SoapMessage)webServiceMessage;
            String soapAction = request.getSoapAction();
            if (StringUtils.hasLength((String)soapAction) && soapAction.charAt(0) == '\"' && soapAction.charAt(soapAction.length() - 1) == '\"') {
                return soapAction.substring(1, soapAction.length() - 1);
            }
            return soapAction;
        }
        return null;
    }

    @Override
    protected boolean validateLookupKey(String key) {
        return StringUtils.hasLength((String)key);
    }
}

