/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.springframework.ws.transport.AbstractWebServiceConnection;
import org.springframework.ws.transport.HeadersAwareReceiverWebServiceConnection;
import org.springframework.ws.transport.TransportInputStream;
import org.springframework.ws.transport.TransportOutputStream;

public abstract class AbstractReceiverConnection
extends AbstractWebServiceConnection
implements HeadersAwareReceiverWebServiceConnection {
    private TransportInputStream requestInputStream;
    private TransportOutputStream responseOutputStream;

    @Override
    protected final TransportInputStream createTransportInputStream() throws IOException {
        if (this.requestInputStream == null) {
            this.requestInputStream = new RequestTransportInputStream();
        }
        return this.requestInputStream;
    }

    @Override
    protected final TransportOutputStream createTransportOutputStream() throws IOException {
        if (this.responseOutputStream == null) {
            this.responseOutputStream = new ResponseTransportOutputStream();
        }
        return this.responseOutputStream;
    }

    @Override
    protected void onClose() throws IOException {
    }

    protected abstract InputStream getRequestInputStream() throws IOException;

    protected abstract OutputStream getResponseOutputStream() throws IOException;

    private final class RequestTransportInputStream
    extends TransportInputStream {
        private RequestTransportInputStream() {
        }

        @Override
        protected InputStream createInputStream() throws IOException {
            return AbstractReceiverConnection.this.getRequestInputStream();
        }

        @Override
        public Iterator<String> getHeaderNames() throws IOException {
            return AbstractReceiverConnection.this.getRequestHeaderNames();
        }

        @Override
        public Iterator<String> getHeaders(String name) throws IOException {
            return AbstractReceiverConnection.this.getRequestHeaders(name);
        }
    }

    private final class ResponseTransportOutputStream
    extends TransportOutputStream {
        private ResponseTransportOutputStream() {
        }

        @Override
        public void addHeader(String name, String value) throws IOException {
            AbstractReceiverConnection.this.addResponseHeader(name, value);
        }

        @Override
        protected OutputStream createOutputStream() throws IOException {
            return AbstractReceiverConnection.this.getResponseOutputStream();
        }
    }
}

