/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.ws.transport.http.LastModifiedHelper;
import org.springframework.ws.transport.http.LocationTransformerObjectSupport;
import org.springframework.ws.wsdl.WsdlDefinition;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Document;

public class WsdlDefinitionHandlerAdapter
extends LocationTransformerObjectSupport
implements HandlerAdapter,
InitializingBean {
    public static final String DEFAULT_LOCATION_EXPRESSION = "//@location";
    public static final String DEFAULT_SCHEMA_LOCATION_EXPRESSION = "//@schemaLocation";
    private static final String CONTENT_TYPE = "text/xml";
    private Map<String, String> expressionNamespaces = new HashMap<String, String>();
    private String locationExpression = "//@location";
    private String schemaLocationExpression = "//@schemaLocation";
    private XPathExpression locationXPathExpression;
    private XPathExpression schemaLocationXPathExpression;
    private boolean transformLocations = false;
    private boolean transformSchemaLocations = false;

    public void setLocationExpression(String locationExpression) {
        this.locationExpression = locationExpression;
    }

    public void setSchemaLocationExpression(String schemaLocationExpression) {
        this.schemaLocationExpression = schemaLocationExpression;
    }

    public void setTransformLocations(boolean transformLocations) {
        this.transformLocations = transformLocations;
    }

    public void setTransformSchemaLocations(boolean transformSchemaLocations) {
        this.transformSchemaLocations = transformSchemaLocations;
    }

    @Deprecated
    public long getLastModified(HttpServletRequest request, Object handler) {
        Source definitionSource = ((WsdlDefinition)handler).getSource();
        return LastModifiedHelper.getLastModified(definitionSource);
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if ("GET".equals(request.getMethod())) {
            WsdlDefinition definition = (WsdlDefinition)handler;
            Transformer transformer = this.createTransformer();
            Source definitionSource = definition.getSource();
            if (this.transformLocations || this.transformSchemaLocations) {
                DOMResult domResult = new DOMResult();
                transformer.transform(definitionSource, domResult);
                Document definitionDocument = (Document)domResult.getNode();
                if (this.transformLocations) {
                    this.transformLocations(definitionDocument, request);
                }
                if (this.transformSchemaLocations) {
                    this.transformSchemaLocations(definitionDocument, request);
                }
                definitionSource = new DOMSource(definitionDocument);
            }
            response.setContentType(CONTENT_TYPE);
            StreamResult responseResult = new StreamResult((OutputStream)response.getOutputStream());
            transformer.transform(definitionSource, responseResult);
        } else {
            response.setStatus(405);
        }
        return null;
    }

    public boolean supports(Object handler) {
        return handler instanceof WsdlDefinition;
    }

    public void afterPropertiesSet() throws Exception {
        this.locationXPathExpression = XPathExpressionFactory.createXPathExpression((String)this.locationExpression, this.expressionNamespaces);
        this.schemaLocationXPathExpression = XPathExpressionFactory.createXPathExpression((String)this.schemaLocationExpression, this.expressionNamespaces);
    }

    protected void transformLocations(Document definitionDocument, HttpServletRequest request) throws Exception {
        this.transformLocations(this.locationXPathExpression, definitionDocument, request);
    }

    protected void transformSchemaLocations(Document definitionDocument, HttpServletRequest request) throws Exception {
        this.transformLocations(this.schemaLocationXPathExpression, definitionDocument, request);
    }
}

