/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http.support;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import org.springframework.util.Assert;
import org.springframework.web.context.AbstractContextLoaderInitializer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.ws.transport.http.MessageDispatcherServlet;

public abstract class AbstractMessageDispatcherServletInitializer
extends AbstractContextLoaderInitializer {
    public static final String DEFAULT_SERVLET_NAME = "messageDispatcher";
    public static final String[] DEFAULT_SERVLET_MAPPINGS = new String[]{"/services", "*.wsdl"};

    public void onStartup(ServletContext servletContext) throws ServletException {
        super.onStartup(servletContext);
        this.registerMessageDispatcherServlet(servletContext);
    }

    protected void registerMessageDispatcherServlet(ServletContext servletContext) {
        String servletName = this.getServletName();
        Assert.hasLength((String)servletName, (String)"getServletName() may not return empty or null");
        WebApplicationContext servletAppContext = this.createServletApplicationContext();
        Assert.notNull((Object)servletAppContext, (String)("createServletApplicationContext() did not return an application context for servlet [" + servletName + "]"));
        MessageDispatcherServlet dispatcherServlet = new MessageDispatcherServlet(servletAppContext);
        dispatcherServlet.setTransformWsdlLocations(this.isTransformWsdlLocations());
        dispatcherServlet.setTransformSchemaLocations(this.isTransformSchemaLocations());
        ServletRegistration.Dynamic registration = servletContext.addServlet(servletName, (Servlet)dispatcherServlet);
        Assert.notNull((Object)registration, (String)("Failed to register servlet with name '" + servletName + "'.Check if there is another servlet registered under the same name."));
        registration.setLoadOnStartup(1);
        registration.addMapping(this.getServletMappings());
        this.customizeRegistration(registration);
    }

    protected String getServletName() {
        return DEFAULT_SERVLET_NAME;
    }

    protected abstract WebApplicationContext createServletApplicationContext();

    protected String[] getServletMappings() {
        return DEFAULT_SERVLET_MAPPINGS;
    }

    public boolean isTransformWsdlLocations() {
        return false;
    }

    protected boolean isTransformSchemaLocations() {
        return false;
    }

    protected void customizeRegistration(ServletRegistration.Dynamic registration) {
    }
}

