/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.core.stat.ChannelStat;
import org.tio.core.stat.IpStat;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.utils.SystemTimer;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class DecodeRunnable
extends AbstractQueueRunnable<ByteBuffer> {
    private static final Logger log = LoggerFactory.getLogger(DecodeRunnable.class);
    private ChannelContext channelContext = null;
    private GroupContext groupContext = null;
    private ByteBuffer lastByteBuffer = null;
    private ByteBuffer newByteBuffer = null;

    public void handler(Packet packet, int byteCount) {
        switch (this.groupContext.packetHandlerMode) {
            case QUEUE: {
                this.channelContext.handlerRunnable.addMsg(packet);
                this.channelContext.handlerRunnable.execute();
                break;
            }
            default: {
                this.channelContext.handlerRunnable.handler(packet);
            }
        }
    }

    public DecodeRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.groupContext = channelContext.groupContext;
    }

    public void clearMsgQueue() {
        super.clearMsgQueue();
        this.lastByteBuffer = null;
        this.newByteBuffer = null;
    }

    public void runTask() {
        while ((this.newByteBuffer = (ByteBuffer)this.msgQueue.poll()) != null) {
            this.decode();
        }
    }

    public void decode() {
        ByteBuffer byteBuffer = this.newByteBuffer;
        if (this.lastByteBuffer != null) {
            byteBuffer = ByteBufferUtils.composite(this.lastByteBuffer, byteBuffer);
            this.lastByteBuffer = null;
        }
        try {
            while (true) {
                int initPosition = byteBuffer.position();
                int limit = byteBuffer.limit();
                int readableLength = limit - initPosition;
                Packet packet = null;
                if (this.channelContext.packetNeededLength != null) {
                    log.info("{}, \u89e3\u7801\u6240\u9700\u957f\u5ea6:{}", (Object)this.channelContext, (Object)this.channelContext.packetNeededLength);
                    if (readableLength >= this.channelContext.packetNeededLength) {
                        packet = this.groupContext.getAioHandler().decode(byteBuffer, limit, initPosition, readableLength, this.channelContext);
                    }
                } else {
                    try {
                        packet = this.groupContext.getAioHandler().decode(byteBuffer, limit, initPosition, readableLength, this.channelContext);
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (packet == null) {
                    if (this.groupContext.useQueueDecode || byteBuffer != this.newByteBuffer) {
                        byteBuffer.position(initPosition);
                        byteBuffer.limit(limit);
                        this.lastByteBuffer = byteBuffer;
                    } else {
                        this.lastByteBuffer = ByteBufferUtils.copy(byteBuffer, initPosition, limit);
                    }
                    ChannelStat channelStat = this.channelContext.stat;
                    ++channelStat.decodeFailCount;
                    log.debug("{} \u672c\u6b21\u89e3\u7801\u5931\u8d25, \u5df2\u7ecf\u8fde\u7eed{}\u6b21\u89e3\u7801\u5931\u8d25\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171{}\u5b57\u8282", new Object[]{this.channelContext, channelStat.decodeFailCount, readableLength});
                    if (channelStat.decodeFailCount > 5) {
                        int per;
                        if (this.channelContext.packetNeededLength == null) {
                            log.info("{} \u672c\u6b21\u89e3\u7801\u5931\u8d25, \u5df2\u7ecf\u8fde\u7eed{}\u6b21\u89e3\u7801\u5931\u8d25\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171{}\u5b57\u8282", new Object[]{this.channelContext, channelStat.decodeFailCount, readableLength});
                        }
                        if (channelStat.decodeFailCount > 10 && (per = readableLength / channelStat.decodeFailCount) < Math.min(this.groupContext.getReadBufferSize() / 2, 256)) {
                            throw new AioDecodeException("\u8fde\u7eed\u89e3\u7801" + channelStat.decodeFailCount + "\u6b21\u90fd\u4e0d\u6210\u529f\uff0c\u5e76\u4e14\u5e73\u5747\u6bcf\u6b21\u63a5\u6536\u5230\u7684\u6570\u636e\u4e3a" + per + "\u5b57\u8282\uff0c\u6709\u6162\u653b\u51fb\u7684\u5acc\u7591");
                        }
                    }
                    return;
                }
                this.channelContext.setPacketNeededLength(null);
                this.channelContext.stat.latestTimeOfReceivedPacket = SystemTimer.currTime;
                this.channelContext.stat.decodeFailCount = 0;
                int len = byteBuffer.position() - initPosition;
                packet.setByteCount(len);
                if (this.groupContext.statOn) {
                    this.groupContext.groupStat.receivedPackets.incrementAndGet();
                    this.channelContext.stat.receivedPackets.incrementAndGet();
                }
                if (this.groupContext.ipStats.durationList != null && this.groupContext.ipStats.durationList.size() > 0) {
                    try {
                        for (Long v : this.groupContext.ipStats.durationList) {
                            IpStat ipStat = this.groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                            ipStat.getReceivedPackets().incrementAndGet();
                            this.groupContext.getIpStatListener().onAfterDecoded(this.channelContext, packet, len, ipStat);
                        }
                    }
                    catch (Exception e1) {
                        log.error(packet.logstr(), (Throwable)e1);
                    }
                }
                if (this.groupContext.getAioListener() != null) {
                    try {
                        this.groupContext.getAioListener().onAfterDecoded(this.channelContext, packet, len);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}, \u89e3\u5305\u83b7\u5f97\u4e00\u4e2apacket:{}", (Object)this.channelContext, (Object)packet.logstr());
                }
                this.handler(packet, len);
                if (!byteBuffer.hasRemaining()) break;
                if (!log.isDebugEnabled()) continue;
                log.debug("{},\u7ec4\u5305\u540e\uff0c\u8fd8\u5269\u6709\u6570\u636e:{}", (Object)this.channelContext, (Object)byteBuffer.remaining());
            }
            this.lastByteBuffer = null;
            log.debug("{},\u7ec4\u5305\u540e\uff0c\u6570\u636e\u521a\u597d\u7528\u5b8c", (Object)this.channelContext);
            return;
        }
        catch (Throwable e) {
            List<Long> list;
            this.channelContext.setPacketNeededLength(null);
            log.error((Object)((Object)this.channelContext) + ", " + byteBuffer + ", \u89e3\u7801\u5f02\u5e38:" + e.toString(), e);
            if (e instanceof AioDecodeException && (list = this.groupContext.ipStats.durationList) != null && list.size() > 0) {
                try {
                    for (Long v : list) {
                        IpStat ipStat = this.groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                        ipStat.getDecodeErrorCount().incrementAndGet();
                        this.groupContext.getIpStatListener().onDecodeError(this.channelContext, ipStat);
                    }
                }
                catch (Exception e1) {
                    log.error(e1.toString(), (Throwable)e1);
                }
            }
            Tio.close(this.channelContext, e, "\u89e3\u7801\u5f02\u5e38:" + e.getMessage());
            return;
        }
    }

    public void setNewByteBuffer(ByteBuffer newByteBuffer) {
        this.newByteBuffer = newByteBuffer;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.channelContext.toString();
    }

    public String logstr() {
        return this.toString();
    }

    private static class LastByteBufferInfo {
        int len = 0;
        ByteBuffer data = null;
        int tempFileIndex = 0;

        private LastByteBufferInfo() {
        }
    }
}

