/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.exception.LengthOverflowException;
import org.tio.utils.hutool.StrUtil;

public class ByteBufferUtils {
    private static Logger log = LoggerFactory.getLogger(ByteBufferUtils.class);

    public static ByteBuffer composite(ByteBuffer byteBuffer1, ByteBuffer byteBuffer2) {
        int capacity = byteBuffer1.remaining() + byteBuffer2.remaining();
        ByteBuffer ret = ByteBuffer.allocate(capacity);
        ret.put(byteBuffer1);
        ret.put(byteBuffer2);
        ret.position(0);
        ret.limit(ret.capacity());
        return ret;
    }

    public static void copy(ByteBuffer src, int srcStartindex, ByteBuffer dest, int destStartIndex, int length) {
        System.arraycopy(src.array(), srcStartindex, dest.array(), destStartIndex, length);
    }

    public static ByteBuffer copy(ByteBuffer src, int startindex, int endindex) {
        int size = endindex - startindex;
        int initPosition = src.position();
        int initLimit = src.limit();
        src.position(startindex);
        src.limit(endindex);
        ByteBuffer ret = ByteBuffer.allocate(size);
        ret.put(src);
        ret.flip();
        src.position(initPosition);
        src.limit(initLimit);
        return ret;
    }

    public static ByteBuffer copy(ByteBuffer src) {
        int startindex = src.position();
        int endindex = src.limit();
        return ByteBufferUtils.copy(src, startindex, endindex);
    }

    public static ByteBuffer[] split(ByteBuffer src, int unitSize) {
        int limit = src.limit();
        if (unitSize >= limit) {
            return null;
        }
        int size = (int)Math.ceil((double)src.limit() / (double)unitSize);
        ByteBuffer[] ret = new ByteBuffer[size];
        int srcIndex = 0;
        for (int i = 0; i < size; ++i) {
            int bufferSize = unitSize;
            if (i == size - 1) {
                bufferSize = src.limit() % unitSize;
            }
            byte[] dest = new byte[bufferSize];
            System.arraycopy(src.array(), srcIndex, dest, 0, dest.length);
            srcIndex += bufferSize;
            ret[i] = ByteBuffer.wrap(dest);
            ret[i].position(0);
            ret[i].limit(ret[i].capacity());
        }
        return ret;
    }

    public static int lineEnd(ByteBuffer buffer) throws LengthOverflowException {
        return ByteBufferUtils.lineEnd(buffer, Integer.MAX_VALUE);
    }

    public static int lineEnd(ByteBuffer buffer, int maxlength) throws LengthOverflowException {
        int initPosition = buffer.position();
        int endPosition = ByteBufferUtils.indexOf(buffer, '\n', maxlength);
        if (endPosition - initPosition > 0 && buffer.get(endPosition - 1) == 13) {
            return endPosition - 1;
        }
        return endPosition;
    }

    public static int indexOf(ByteBuffer buffer, char theChar, int maxlength) throws LengthOverflowException {
        boolean needJudgeLengthOverflow;
        int count = 0;
        boolean bl = needJudgeLengthOverflow = buffer.remaining() > maxlength;
        while (buffer.hasRemaining()) {
            if (buffer.get() == theChar) {
                return buffer.position() - 1;
            }
            if (!needJudgeLengthOverflow || ++count <= maxlength) continue;
            throw new LengthOverflowException("maxlength is " + maxlength);
        }
        return -1;
    }

    public static byte[] readBytes(ByteBuffer buffer, int length) {
        byte[] ab = new byte[length];
        buffer.get(ab);
        return ab;
    }

    public static String readString(ByteBuffer buffer, int length, String charset) throws UnsupportedEncodingException {
        byte[] bs = ByteBufferUtils.readBytes(buffer, length);
        if (StrUtil.isNotBlank((CharSequence)charset)) {
            return new String(bs, charset);
        }
        return new String(bs);
    }

    public static String readLine(ByteBuffer buffer, String charset) throws LengthOverflowException {
        return ByteBufferUtils.readLine(buffer, charset, Integer.MAX_VALUE);
    }

    public static String readLine(ByteBuffer buffer, String charset, Integer maxlength) throws LengthOverflowException {
        int startPosition = buffer.position();
        int endPosition = ByteBufferUtils.lineEnd(buffer, maxlength);
        if (endPosition == -1) {
            return null;
        }
        int nowPosition = buffer.position();
        if (endPosition > startPosition) {
            byte[] bs = new byte[endPosition - startPosition];
            buffer.position(startPosition);
            buffer.get(bs);
            buffer.position(nowPosition);
            if (StrUtil.isNotBlank((CharSequence)charset)) {
                try {
                    return new String(bs, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new String(bs);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static String readString(ByteBuffer buffer, String charset, char endChar, Integer maxlength) throws LengthOverflowException {
        int startPosition = buffer.position();
        int endPosition = ByteBufferUtils.indexOf(buffer, endChar, maxlength);
        if (endPosition == -1) {
            return null;
        }
        int nowPosition = buffer.position();
        if (endPosition > startPosition) {
            byte[] bs = new byte[endPosition - startPosition];
            buffer.position(startPosition);
            buffer.get(bs);
            buffer.position(nowPosition);
            if (StrUtil.isNotBlank((CharSequence)charset)) {
                try {
                    return new String(bs, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new String(bs);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static int readUB1(ByteBuffer buffer) {
        int ret = buffer.get() & 0xFF;
        return ret;
    }

    public static int readUB2(ByteBuffer buffer) {
        int ret = buffer.get() & 0xFF;
        return ret |= (buffer.get() & 0xFF) << 8;
    }

    public static int readUB2WithBigEdian(ByteBuffer buffer) {
        int ret = (buffer.get() & 0xFF) << 8;
        return ret |= buffer.get() & 0xFF;
    }

    public static long readUB4(ByteBuffer buffer) {
        long ret = buffer.get() & 0xFF;
        ret |= (long)(buffer.get() & 0xFF) << 8;
        ret |= (long)(buffer.get() & 0xFF) << 16;
        return ret |= (long)(buffer.get() & 0xFF) << 24;
    }

    public static long readUB4WithBigEdian(ByteBuffer buffer) {
        long ret = (long)(buffer.get() & 0xFF) << 24;
        ret |= (long)(buffer.get() & 0xFF) << 16;
        ret |= (long)(buffer.get() & 0xFF) << 8;
        return ret |= (long)(buffer.get() & 0xFF);
    }

    public static final void writeUB2(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
    }

    public static final void writeUB2WithBigEdian(ByteBuffer buffer, int i) {
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i & 0xFF));
    }

    public static final void writeUB4(ByteBuffer buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
    }

    public static final void writeUB4WithBigEdian(ByteBuffer buffer, long l) {
        buffer.put((byte)(l >>> 24));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l & 0xFFL));
    }
}

