/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.ServerGroupContext;
import org.tio.utils.date.DateUtils;
import org.tio.utils.hutool.StrUtil;

public class TioServer {
    private static Logger log = LoggerFactory.getLogger(TioServer.class);
    private ServerGroupContext serverGroupContext;
    private AsynchronousServerSocketChannel serverSocketChannel;
    private AsynchronousChannelGroup channelGroup = null;
    private Node serverNode;
    private boolean isWaitingStop = false;

    public TioServer(ServerGroupContext serverGroupContext) {
        this.serverGroupContext = serverGroupContext;
    }

    public ServerGroupContext getServerGroupContext() {
        return this.serverGroupContext;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public AsynchronousServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public boolean isWaitingStop() {
        return this.isWaitingStop;
    }

    public void setServerGroupContext(ServerGroupContext serverGroupContext) {
        this.serverGroupContext = serverGroupContext;
    }

    public void setWaitingStop(boolean isWaitingStop) {
        this.isWaitingStop = isWaitingStop;
    }

    public void start(String serverIp, int serverPort) throws IOException {
        long start = System.currentTimeMillis();
        this.serverNode = new Node(serverIp, serverPort);
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(this.serverGroupContext.groupExecutor);
        this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.channelGroup);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
        InetSocketAddress listenAddress = null;
        listenAddress = StrUtil.isBlank((CharSequence)serverIp) ? new InetSocketAddress(serverPort) : new InetSocketAddress(serverIp, serverPort);
        this.serverSocketChannel.bind(listenAddress, 0);
        AcceptCompletionHandler acceptCompletionHandler = this.serverGroupContext.getAcceptCompletionHandler();
        this.serverSocketChannel.accept(this, acceptCompletionHandler);
        this.serverGroupContext.startTime = System.currentTimeMillis();
        String baseStr = "|----------------------------------------------------------------------------------------|";
        int baseLen = baseStr.length();
        StackTraceElement[] ses = Thread.currentThread().getStackTrace();
        StackTraceElement se = ses[ses.length - 1];
        int xxLen = 18;
        int aaLen = baseLen - 3;
        ArrayList<String> infoList = new ArrayList<String>();
        infoList.add(StrUtil.fillAfter((String)"Tio gitee address", (char)' ', (int)xxLen) + "| " + "https://gitee.com/tywo45/t-io");
        infoList.add(StrUtil.fillAfter((String)"Tio site address", (char)' ', (int)xxLen) + "| " + "https://t-io.org/");
        infoList.add(StrUtil.fillAfter((String)"Tio version", (char)' ', (int)xxLen) + "| " + "3.2.0.v20180918-RELEASE");
        infoList.add(StrUtil.fillAfter((String)"-", (char)'-', (int)aaLen));
        infoList.add(StrUtil.fillAfter((String)"GroupContext name", (char)' ', (int)xxLen) + "| " + this.serverGroupContext.getName());
        infoList.add(StrUtil.fillAfter((String)"Started at", (char)' ', (int)xxLen) + "| " + DateUtils.formatDateTime((Date)new Date()));
        infoList.add(StrUtil.fillAfter((String)"Listen on", (char)' ', (int)xxLen) + "| " + this.serverNode);
        infoList.add(StrUtil.fillAfter((String)"Main Class", (char)' ', (int)xxLen) + "| " + se.getClassName());
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            String runtimeName = runtimeMxBean.getName();
            String pid = runtimeName.split("@")[0];
            long startTime = runtimeMxBean.getStartTime();
            long startCost = System.currentTimeMillis() - startTime;
            infoList.add(StrUtil.fillAfter((String)"Jvm start time", (char)' ', (int)xxLen) + "| " + startCost + " ms");
            infoList.add(StrUtil.fillAfter((String)"Tio start time", (char)' ', (int)xxLen) + "| " + (System.currentTimeMillis() - start) + " ms");
            infoList.add(StrUtil.fillAfter((String)"Pid", (char)' ', (int)xxLen) + "| " + pid);
        }
        catch (Exception runtimeMxBean) {
            // empty catch block
        }
        String printStr = "\r\n" + baseStr + "\r\n";
        for (String string : infoList) {
            printStr = printStr + "| " + StrUtil.fillAfter((String)string, (char)' ', (int)aaLen) + "|\r\n";
        }
        printStr = printStr + baseStr + "\r\n";
        if (log.isInfoEnabled()) {
            log.info(printStr);
        } else {
            System.out.println(printStr);
        }
    }

    public boolean stop() {
        this.isWaitingStop = true;
        boolean ret = true;
        try {
            this.channelGroup.shutdownNow();
        }
        catch (Exception e) {
            log.error("channelGroup.shutdownNow()\u65f6\u62a5\u9519", (Throwable)e);
        }
        try {
            this.serverSocketChannel.close();
        }
        catch (Exception e1) {
            log.error("serverSocketChannel.close()\u65f6\u62a5\u9519", (Throwable)e1);
        }
        try {
            this.serverGroupContext.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        try {
            this.serverGroupContext.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        this.serverGroupContext.setStopped(true);
        try {
            ret = ret && this.serverGroupContext.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.serverGroupContext.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info(this.serverNode + " stopped");
        return ret;
    }
}

