/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;
import se.jiderhamn.classloader.leak.prevention.PreClassLoaderInitiator;

public class ReplaceDOMNormalizerSerializerAbortException
implements PreClassLoaderInitiator,
ClassLoaderPreMortemCleanUp {
    @Override
    public void doOutsideClassLoader(ClassLoaderLeakPreventor preventor) {
        this.replaceDOMNormalizerSerializerAbortException(preventor);
    }

    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        this.replaceDOMNormalizerSerializerAbortException(preventor);
    }

    protected void replaceDOMNormalizerSerializerAbortException(ClassLoaderLeakPreventor preventor) {
        RuntimeException abort = this.constructRuntimeExceptionWithoutStackTrace(preventor, "abort", null);
        if (abort != null) {
            Field serializerAbort;
            Field normalizerAbort = preventor.findFieldOfClass("com.sun.org.apache.xerces.internal.dom.DOMNormalizer", "abort");
            if (normalizerAbort != null) {
                preventor.setFinalStaticField(normalizerAbort, abort);
            }
            if ((serializerAbort = preventor.findFieldOfClass("com.sun.org.apache.xml.internal.serialize.DOMSerializerImpl", "abort")) != null) {
                preventor.setFinalStaticField(serializerAbort, abort);
            }
        }
    }

    protected RuntimeException constructRuntimeExceptionWithoutStackTrace(ClassLoaderLeakPreventor preventor, String message, Throwable cause) {
        try {
            Constructor constructor = RuntimeException.class.getDeclaredConstructor(String.class, Throwable.class, Boolean.TYPE, Boolean.TYPE);
            constructor.setAccessible(true);
            return (RuntimeException)constructor.newInstance(message, cause, true, false);
        }
        catch (Throwable e) {
            preventor.warn("Unable to construct RuntimeException without stack trace. The likely reason is that you are using Java <= 1.6. No worries, except there is one kind of leak you're not protected from (https://github.com/mjiderhamn/classloader-leak-prevention/issues/36). If you are already on Java 1.7+, please report issue to developer of this library!");
            preventor.warn(e);
            return null;
        }
    }
}

