/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class DefaultAuthenticatorCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Authenticator defaultAuthenticator = this.getDefaultAuthenticator(preventor);
        if (defaultAuthenticator == null || preventor.isLoadedInClassLoader(defaultAuthenticator)) {
            if (defaultAuthenticator != null) {
                preventor.warn("Unsetting default " + Authenticator.class.getName() + ": " + defaultAuthenticator);
            }
            Authenticator.setDefault(null);
        } else {
            Reference reference;
            Object referencedAuth;
            Object authReference;
            Object cxfAuthenticator$instance;
            Class<?> cxfAuthenticator;
            if ("org.apache.cxf.transport.http.ReferencingAuthenticator".equals(defaultAuthenticator.getClass().getName()) && (cxfAuthenticator = preventor.findClass("org.apache.cxf.transport.http.CXFAuthenticator")) != null && preventor.isLoadedByClassLoader(cxfAuthenticator) && (cxfAuthenticator$instance = preventor.getStaticFieldValue(cxfAuthenticator, "instance")) != null && (authReference = preventor.getFieldValue(defaultAuthenticator, "auth")) instanceof Reference && (referencedAuth = (reference = (Reference)authReference).get()) == cxfAuthenticator$instance) {
                preventor.warn("Default " + Authenticator.class.getName() + " was " + defaultAuthenticator + " that referenced " + cxfAuthenticator$instance + " loaded by protected ClassLoader");
                reference.clear();
                try {
                    Method check = defaultAuthenticator.getClass().getMethod("check", new Class[0]);
                    check.setAccessible(true);
                    check.invoke((Object)defaultAuthenticator, new Object[0]);
                }
                catch (Exception e) {
                    preventor.error(e);
                }
            }
            this.removeWrappedAuthenticators(preventor, defaultAuthenticator);
            preventor.info("Default " + Authenticator.class.getName() + " not loaded by protected ClassLoader: " + defaultAuthenticator);
        }
    }

    protected Authenticator getDefaultAuthenticator(ClassLoaderLeakPreventor preventor) {
        for (Field f : Authenticator.class.getDeclaredFields()) {
            if (!f.getType().equals(Authenticator.class)) continue;
            try {
                f.setAccessible(true);
                return (Authenticator)f.get(null);
            }
            catch (Exception e) {
                preventor.error(e);
            }
        }
        return null;
    }

    protected void removeWrappedAuthenticators(ClassLoaderLeakPreventor preventor, Authenticator authenticator) {
        if (authenticator == null) {
            return;
        }
        try {
            Class<?> authenticatorClass = authenticator.getClass();
            do {
                for (Field f : authenticator.getClass().getDeclaredFields()) {
                    if (!Authenticator.class.isAssignableFrom(f.getType())) continue;
                    try {
                        boolean isStatic = Modifier.isStatic(f.getModifiers());
                        Authenticator owner = isStatic ? null : authenticator;
                        f.setAccessible(true);
                        Authenticator wrapped = (Authenticator)f.get(owner);
                        if (preventor.isLoadedInClassLoader(wrapped)) {
                            preventor.warn(Authenticator.class.getName() + ": " + wrapped + ", wrapped by " + authenticator + ", is loaded by protected ClassLoader");
                            f.set(owner, null);
                            continue;
                        }
                        this.removeWrappedAuthenticators(preventor, wrapped);
                    }
                    catch (Exception e) {
                        preventor.error(e);
                    }
                }
            } while ((authenticatorClass = authenticatorClass.getSuperclass()) != null && authenticatorClass != Object.class);
        }
        catch (Exception e) {
            preventor.error(e);
        }
    }
}

