/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class DriverManagerCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        ArrayList<Driver> driversToDeregister = new ArrayList<Driver>();
        Enumeration<Driver> allDrivers = DriverManager.getDrivers();
        while (allDrivers.hasMoreElements()) {
            Driver driver = allDrivers.nextElement();
            if (!preventor.isLoadedInClassLoader(driver)) continue;
            driversToDeregister.add(driver);
        }
        for (Driver driver : driversToDeregister) {
            try {
                preventor.warn("JDBC driver loaded by protected ClassLoader deregistered: " + driver.getClass());
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                preventor.error(e);
            }
        }
    }
}

