/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ServiceRegistry;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class IIOServiceProviderCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(final ClassLoaderLeakPreventor preventor) {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<Class<?>> categories = registry.getCategories();
        ServiceRegistry.Filter classLoaderFilter = new ServiceRegistry.Filter(){

            @Override
            public boolean filter(Object provider) {
                return preventor.isLoadedInClassLoader(provider);
            }
        };
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            Iterator<?> serviceProviders = registry.getServiceProviders(category, classLoaderFilter, true);
            if (!serviceProviders.hasNext()) continue;
            ArrayList serviceProviderList = new ArrayList();
            while (serviceProviders.hasNext()) {
                serviceProviderList.add(serviceProviders.next());
            }
            for (IIOServiceProvider serviceProvider : serviceProviderList) {
                preventor.warn("ImageIO " + category.getSimpleName() + " service provider deregistered: " + serviceProvider.getDescription(Locale.ROOT));
                registry.deregisterServiceProvider(serviceProvider);
            }
        }
    }
}

