/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.util.HashSet;
import java.util.WeakHashMap;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class JavaServerFaces2746CleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Object o = preventor.getStaticFieldValue("javax.faces.component.UIComponentBase", "descriptors");
        if (o instanceof WeakHashMap) {
            WeakHashMap descriptors = (WeakHashMap)o;
            HashSet<Class> toRemove = new HashSet<Class>();
            for (Object key : descriptors.keySet()) {
                if (!(key instanceof Class) || !preventor.isLoadedByClassLoader((Class)key)) continue;
                toRemove.add((Class)key);
            }
            if (!toRemove.isEmpty()) {
                preventor.info("Removing " + toRemove.size() + " classes from Mojarra descriptors cache");
                for (Class clazz : toRemove) {
                    descriptors.remove(clazz);
                }
            }
        }
    }
}

