/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class PropertyEditorCleanUp
implements ClassLoaderPreMortemCleanUp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Field registryField = preventor.findField(PropertyEditorManager.class, "registry");
        if (registryField == null) {
            preventor.error("Internal registry of " + PropertyEditorManager.class.getName() + " not found");
        } else {
            try {
                Class<PropertyEditorManager> clazz = PropertyEditorManager.class;
                synchronized (PropertyEditorManager.class) {
                    Map registry = (Map)registryField.get(null);
                    if (registry != null) {
                        HashSet toRemove = new HashSet();
                        for (Map.Entry entry : registry.entrySet()) {
                            if (!preventor.isLoadedByClassLoader((Class)entry.getKey()) && !preventor.isLoadedByClassLoader((Class)entry.getValue())) continue;
                            toRemove.add(entry.getKey());
                        }
                        for (Class clazz2 : toRemove) {
                            preventor.warn("Property editor for type " + clazz2 + " = " + registry.get(clazz2) + " needs to be deregistered");
                            PropertyEditorManager.registerEditor(clazz2, null);
                        }
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                preventor.error(e);
            }
        }
        {
            return;
        }
    }
}

