/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class ResourceBundleCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        try {
            try {
                Method clearCache16 = ResourceBundle.class.getMethod("clearCache", ClassLoader.class);
                preventor.debug("Since Java 1.6+ is used, we can call " + clearCache16);
                clearCache16.invoke(null, preventor.getClassLoader());
            }
            catch (NoSuchMethodException e) {
                Map cacheList = (Map)preventor.getStaticFieldValue(ResourceBundle.class, "cacheList");
                Iterator iter = cacheList.keySet().iterator();
                Field loaderRefField = null;
                while (iter.hasNext()) {
                    WeakReference loaderRef;
                    ClassLoader classLoader;
                    Object key = iter.next();
                    if (loaderRefField == null) {
                        loaderRefField = key.getClass().getDeclaredField("loaderRef");
                        loaderRefField.setAccessible(true);
                    }
                    if (!preventor.isClassLoaderOrChild(classLoader = (ClassLoader)(loaderRef = (WeakReference)loaderRefField.get(key)).get())) continue;
                    preventor.info("Removing ResourceBundle from cache: " + key);
                    iter.remove();
                }
            }
        }
        catch (Exception ex) {
            preventor.error(ex);
        }
    }
}

