/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class SecurityProviderCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        HashSet<String> providersToRemove = new HashSet<String>();
        for (Provider provider : Security.getProviders()) {
            if (!preventor.isLoadedInClassLoader(provider)) continue;
            providersToRemove.add(provider.getName());
        }
        if (!providersToRemove.isEmpty()) {
            preventor.warn("Removing security providers loaded by protected ClassLoader: " + providersToRemove);
            for (String providerName : providersToRemove) {
                Security.removeProvider(providerName);
            }
        }
    }
}

