/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class StopThreadsCleanUp
implements ClassLoaderPreMortemCleanUp {
    protected static final String JURT_ASYNCHRONOUS_FINALIZER = "com.sun.star.lib.util.AsynchronousFinalizer";
    protected boolean stopThreads;
    protected int threadWaitMs = 5000;
    protected boolean stopTimerThreads;

    public StopThreadsCleanUp() {
        this(true, true);
    }

    public StopThreadsCleanUp(boolean stopThreads, boolean stopTimerThreads) {
        this.stopThreads = stopThreads;
        this.stopTimerThreads = stopTimerThreads;
    }

    public void setStopThreads(boolean stopThreads) {
        this.stopThreads = stopThreads;
    }

    public void setStopTimerThreads(boolean stopTimerThreads) {
        this.stopTimerThreads = stopTimerThreads;
    }

    public void setThreadWaitMs(int threadWaitMs) {
        this.threadWaitMs = threadWaitMs;
    }

    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        this.forceStartOpenOfficeJurtCleanup(preventor);
        this.stopThreads(preventor);
    }

    protected void forceStartOpenOfficeJurtCleanup(ClassLoaderLeakPreventor preventor) {
        if (this.stopThreads) {
            if (preventor.isLoadedByClassLoader(preventor.findClass(JURT_ASYNCHRONOUS_FINALIZER))) {
                preventor.info("OpenOffice JURT AsynchronousFinalizer thread started - forcing garbage collection to invoke finalizers");
                ClassLoaderLeakPreventor.gc();
            }
        } else if (preventor.getClassLoader().getResource("com/sun/star/lib/util/AsynchronousFinalizer.class") != null) {
            preventor.warn("OpenOffice JURT AsynchronousFinalizer thread will not be stopped if started, as stopThreads is false");
            ClassLoaderLeakPreventor.gc();
        }
    }

    protected void stopThreads(ClassLoaderLeakPreventor preventor) {
        Class<?> workerClass = preventor.findClass("java.util.concurrent.ThreadPoolExecutor$Worker");
        Field oracleTarget = preventor.findField(Thread.class, "target");
        Field ibmRunnable = preventor.findField(Thread.class, "runnable");
        boolean waitForThreads = this.threadWaitMs > 0;
        for (Thread thread : preventor.getAllThreads()) {
            Runnable runnable = oracleTarget != null ? (Runnable)preventor.getFieldValue(oracleTarget, thread) : (Runnable)preventor.getFieldValue(ibmRunnable, thread);
            boolean runnableLoadedInWebApplication = preventor.isLoadedInClassLoader(runnable);
            if (thread == Thread.currentThread() || !preventor.isThreadInClassLoader(thread) && !runnableLoadedInWebApplication) continue;
            if (thread.getClass().getName().startsWith(JURT_ASYNCHRONOUS_FINALIZER)) {
                if (this.stopThreads) {
                    preventor.info("Found JURT thread " + thread.getName() + "; starting " + JURTKiller.class.getSimpleName());
                    new JURTKiller(preventor, thread).start();
                    continue;
                }
                preventor.warn("JURT thread " + thread.getName() + " is still running in web app");
                continue;
            }
            if (thread.getThreadGroup() != null && ("system".equals(thread.getThreadGroup().getName()) || "RMI Runtime".equals(thread.getThreadGroup().getName()))) {
                if (!"Keep-Alive-Timer".equals(thread.getName())) continue;
                thread.setContextClassLoader(preventor.getLeakSafeClassLoader());
                preventor.debug("Changed contextClassLoader of HTTP keep alive thread");
                continue;
            }
            if (!thread.isAlive()) continue;
            if ("java.util.TimerThread".equals(thread.getClass().getName())) {
                if (thread.getName() != null && thread.getName().startsWith("PostgreSQL-JDBC-SharedTimer-")) {
                    Field inheritedAccessControlContext;
                    if (preventor.isClassLoaderOrChild(thread.getContextClassLoader())) {
                        Class<?> postgresqlDriver = preventor.findClass("org.postgresql.Driver");
                        ClassLoader postgresqlCL = postgresqlDriver != null && !preventor.isLoadedByClassLoader(postgresqlDriver) ? postgresqlDriver.getClassLoader() : preventor.getLeakSafeClassLoader();
                        thread.setContextClassLoader(postgresqlCL);
                        preventor.warn("Changing contextClassLoader of " + thread + " to " + postgresqlCL);
                    }
                    if ((inheritedAccessControlContext = preventor.findField(Thread.class, "inheritedAccessControlContext")) == null) continue;
                    try {
                        AccessControlContext acc = preventor.createAccessControlContext();
                        inheritedAccessControlContext.set(thread, acc);
                        preventor.removeDomainCombiner(thread, acc);
                    }
                    catch (Exception e) {
                        preventor.error(e);
                    }
                    continue;
                }
                if (this.stopTimerThreads) {
                    preventor.warn("Stopping Timer thread '" + thread.getName() + "' running in classloader.");
                    this.stopTimerThread(preventor, thread);
                    continue;
                }
                preventor.info("Timer thread is running in classloader, but will not be stopped");
                continue;
            }
            if (workerClass != null && workerClass.isInstance(runnable)) {
                if (this.stopThreads) {
                    preventor.warn("Shutting down " + ThreadPoolExecutor.class.getName() + " running within the classloader.");
                    try {
                        Field workerExecutor = preventor.findField(workerClass, "this$0");
                        ThreadPoolExecutor executor = (ThreadPoolExecutor)preventor.getFieldValue(workerExecutor, runnable);
                        executor.shutdownNow();
                    }
                    catch (Exception ex) {
                        preventor.error(ex);
                    }
                } else {
                    preventor.info(ThreadPoolExecutor.class.getName() + " running within the classloader will not be shut down.");
                }
            }
            String displayString = "'" + thread + "' of type " + thread.getClass().getName();
            if (!preventor.isLoadedInClassLoader(thread) && !runnableLoadedInWebApplication) {
                if (waitForThreads) {
                    preventor.warn("Thread " + displayString + " running in web app; waiting " + this.threadWaitMs);
                    preventor.waitForThread(thread, this.threadWaitMs);
                }
                if (!thread.isAlive() || !preventor.isClassLoaderOrChild(thread.getContextClassLoader())) continue;
                preventor.warn("Thread " + displayString + (waitForThreads ? " still" : "") + " running in web app; changing context classloader to system classloader");
                thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                continue;
            }
            if (this.stopThreads) {
                String waitString = waitForThreads ? "after " + this.threadWaitMs + " ms " : "";
                preventor.warn("Stopping Thread " + displayString + " running in web app " + waitString);
                preventor.waitForThread(thread, this.threadWaitMs);
                if (!thread.isAlive()) continue;
                thread.stop();
                continue;
            }
            preventor.warn("Thread " + displayString + " is still running in web app");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimerThread(ClassLoaderLeakPreventor preventor, Thread thread) {
        try {
            Field newTasksMayBeScheduled = preventor.findField(thread.getClass(), "newTasksMayBeScheduled");
            Object queue = preventor.findField(thread.getClass(), "queue").get(thread);
            Method clear = preventor.findMethod(queue.getClass(), "clear", new Class[0]);
            Object object = queue;
            synchronized (object) {
                newTasksMayBeScheduled.set(thread, Boolean.FALSE);
                clear.invoke(queue, new Object[0]);
                queue.notify();
            }
        }
        catch (Exception ex) {
            preventor.error(ex);
        }
    }

    protected class JURTKiller
    extends Thread {
        private final ClassLoaderLeakPreventor preventor;
        private final Thread jurtThread;
        private final List<?> jurtQueue;

        public JURTKiller(ClassLoaderLeakPreventor preventor, Thread jurtThread) {
            super("JURTKiller");
            this.preventor = preventor;
            this.jurtThread = jurtThread;
            this.jurtQueue = (List)preventor.getStaticFieldValue(StopThreadsCleanUp.JURT_ASYNCHRONOUS_FINALIZER, "queue");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.jurtQueue == null || this.jurtThread == null) {
                this.preventor.error(this.getName() + ": No queue or thread!?");
                return;
            }
            if (!this.jurtThread.isAlive()) {
                this.preventor.warn(this.getName() + ": " + this.jurtThread.getName() + " is already dead?");
            }
            boolean queueIsEmpty = false;
            while (!queueIsEmpty) {
                try {
                    this.preventor.debug(this.getName() + " goes to sleep for " + 5000 + " ms");
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Thread.State.RUNNABLE != this.jurtThread.getState()) {
                    this.preventor.debug(this.getName() + " about to force Garbage Collection");
                    ClassLoaderLeakPreventor.gc();
                    List<?> list = this.jurtQueue;
                    synchronized (list) {
                        queueIsEmpty = this.jurtQueue.isEmpty();
                        this.preventor.debug(this.getName() + ": JURT queue is empty? " + queueIsEmpty);
                        continue;
                    }
                }
                this.preventor.debug(this.getName() + ": JURT thread " + this.jurtThread.getName() + " is executing Job");
            }
            this.preventor.info(this.getName() + " about to kill " + this.jurtThread);
            if (this.jurtThread.isAlive()) {
                this.jurtThread.stop();
            }
        }
    }
}

