/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class ThreadGroupContextCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        WeakReference[] table;
        Field tableField;
        Object contexts = preventor.getStaticFieldValue("java.beans.ThreadGroupContext", "contexts");
        if (contexts != null && (tableField = preventor.findField(preventor.findClass("java.beans.WeakIdentityMap"), "table")) != null && (table = (WeakReference[])preventor.getFieldValue(tableField, contexts)) != null) {
            Method clearBeanInfoCache = null;
            for (WeakReference entry : table) {
                Object context;
                if (entry == null || (context = preventor.getFieldValue(entry, "value")) == null) continue;
                if (clearBeanInfoCache == null) {
                    clearBeanInfoCache = preventor.findMethod(context.getClass(), "clearBeanInfoCache", new Class[0]);
                }
                try {
                    clearBeanInfoCache.invoke(context, new Object[0]);
                }
                catch (Exception e) {
                    preventor.error(e);
                }
            }
        }
    }
}

