/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;
import se.jiderhamn.classloader.leak.prevention.MustBeAfter;
import se.jiderhamn.classloader.leak.prevention.cleanup.StopThreadsCleanUp;

public class ThreadLocalCleanUp
implements ClassLoaderPreMortemCleanUp,
MustBeAfter<ClassLoaderPreMortemCleanUp> {
    private static final String CAUCHO_TRANSACTION_IMPL = "com.caucho.transaction.TransactionImpl";
    protected Field java_lang_Thread_threadLocals;
    protected Field java_lang_Thread_inheritableThreadLocals;
    protected Field java_lang_ThreadLocal$ThreadLocalMap_table;
    protected Field java_lang_ThreadLocal$ThreadLocalMap$Entry_value;

    @Override
    public Class<? extends ClassLoaderPreMortemCleanUp>[] mustBeBeforeMe() {
        return new Class[]{StopThreadsCleanUp.class};
    }

    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        this.initFields(preventor);
        if (this.java_lang_Thread_threadLocals == null) {
            preventor.error("java.lang.Thread.threadLocals not found; something is seriously wrong!");
        }
        if (this.java_lang_Thread_inheritableThreadLocals == null) {
            preventor.error("java.lang.Thread.inheritableThreadLocals not found; something is seriously wrong!");
        }
        if (this.java_lang_ThreadLocal$ThreadLocalMap_table == null) {
            preventor.error("java.lang.ThreadLocal$ThreadLocalMap.table not found; something is seriously wrong!");
        }
        for (Thread thread : preventor.getAllThreads()) {
            this.forEachThreadLocalInThread(preventor, thread);
        }
    }

    private void initFields(ClassLoaderLeakPreventor preventor) {
        if (this.java_lang_Thread_threadLocals == null) {
            this.java_lang_Thread_threadLocals = preventor.findField(Thread.class, "threadLocals");
            this.java_lang_Thread_inheritableThreadLocals = preventor.findField(Thread.class, "inheritableThreadLocals");
            this.java_lang_ThreadLocal$ThreadLocalMap_table = preventor.findFieldOfClass("java.lang.ThreadLocal$ThreadLocalMap", "table");
        }
    }

    protected void forEachThreadLocalInThread(ClassLoaderLeakPreventor preventor, Thread thread) {
        try {
            if (this.java_lang_Thread_threadLocals != null) {
                this.processThreadLocalMap(preventor, thread, this.java_lang_Thread_threadLocals.get(thread));
            }
            if (this.java_lang_Thread_inheritableThreadLocals != null) {
                this.processThreadLocalMap(preventor, thread, this.java_lang_Thread_inheritableThreadLocals.get(thread));
            }
        }
        catch (Exception ex) {
            preventor.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processThreadLocalMap(ClassLoaderLeakPreventor preventor, Thread thread, Object threadLocalMap) throws IllegalAccessException {
        if (threadLocalMap != null && this.java_lang_ThreadLocal$ThreadLocalMap_table != null) {
            Object[] threadLocalMapTable;
            Field resin_suspendState = null;
            Field resin_isSuspended = null;
            for (Object entry : threadLocalMapTable = (Object[])this.java_lang_ThreadLocal$ThreadLocalMap_table.get(threadLocalMap)) {
                Object value;
                if (entry == null) continue;
                Reference reference = (Reference)entry;
                ThreadLocal threadLocal = (ThreadLocal)reference.get();
                if (this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value == null) {
                    this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value = preventor.findField(entry.getClass(), "value");
                }
                if ((value = this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value.get(entry)) != null && CAUCHO_TRANSACTION_IMPL.equals(value.getClass().getName())) {
                    if (resin_suspendState == null && resin_isSuspended == null) {
                        resin_suspendState = preventor.findField(value.getClass(), "_suspendState");
                        resin_isSuspended = preventor.findField(value.getClass(), "_isSuspended");
                    }
                    if (resin_suspendState != null && resin_isSuspended != null && preventor.getFieldValue(resin_suspendState, value) != null) {
                        try {
                            thread.suspend();
                            if (preventor.getFieldValue(resin_suspendState, value) != null) {
                                Object isSuspended = preventor.getFieldValue(resin_isSuspended, value);
                                if (!(isSuspended instanceof Boolean)) {
                                    preventor.error(thread.toString() + " has " + CAUCHO_TRANSACTION_IMPL + " but _isSuspended is not boolean: " + isSuspended);
                                } else if (((Boolean)isSuspended).booleanValue()) {
                                    preventor.debug(thread.toString() + " has " + CAUCHO_TRANSACTION_IMPL + " that is suspended");
                                } else {
                                    resin_suspendState.set(value, null);
                                    preventor.error(thread.toString() + " had " + CAUCHO_TRANSACTION_IMPL + " with unused _suspendState that was removed");
                                }
                            }
                        }
                        catch (Throwable t) {
                            preventor.error(t);
                        }
                        finally {
                            thread.resume();
                        }
                    }
                }
                boolean customThreadLocal = preventor.isLoadedInClassLoader(threadLocal);
                boolean valueLoadedInWebApp = preventor.isLoadedInClassLoader(value);
                if (!customThreadLocal && !valueLoadedInWebApp && (!(value instanceof ClassLoader) || !preventor.isClassLoaderOrChild((ClassLoader)value))) continue;
                StringBuilder message = new StringBuilder();
                if (threadLocal != null) {
                    if (customThreadLocal) {
                        message.append("Custom ");
                    }
                    message.append("ThreadLocal of type ").append(threadLocal.getClass().getName()).append(": ").append(threadLocal);
                } else {
                    message.append("Unknown ThreadLocal");
                }
                message.append(" with value ").append(value);
                if (value != null) {
                    message.append(" of type ").append(value.getClass().getName());
                    if (valueLoadedInWebApp) {
                        message.append(" that is loaded by web app");
                    }
                }
                this.processLeak(preventor, thread, reference, threadLocal, value, message.toString());
            }
        }
    }

    protected void processLeak(ClassLoaderLeakPreventor preventor, Thread thread, Reference<?> entry, ThreadLocal<?> threadLocal, Object value, String message) {
        if (threadLocal != null && thread == Thread.currentThread()) {
            preventor.info(message + " will be remove()d from " + thread);
            threadLocal.remove();
        } else {
            preventor.info(message + " will be made stale for later expunging from " + thread);
        }
        entry.clear();
        if (this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value == null) {
            this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value = preventor.findField(entry.getClass(), "value");
        }
        try {
            this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value.set(entry, null);
        }
        catch (IllegalAccessException iaex) {
            preventor.error(iaex);
        }
    }
}

