/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.zoo;

import ai.djl.Application;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class PpModelZoo
extends ModelZoo {
    private static final String DJL_REPO_URL = "https://mlrepo.djl.ai/";
    private static final Repository REPOSITORY = Repository.newInstance((String)"Paddle", (String)"https://mlrepo.djl.ai/");
    public static final String GROUP_ID = "ai.djl.paddlepaddle";
    private static final List<ModelLoader> MODEL_LOADERS = new ArrayList<ModelLoader>();

    public List<ModelLoader> getModelLoaders() {
        return MODEL_LOADERS;
    }

    public String getGroupId() {
        return GROUP_ID;
    }

    public Set<String> getSupportedEngines() {
        return Collections.singleton("PaddlePaddle");
    }

    static {
        MRL maskDetection = REPOSITORY.model(Application.CV.IMAGE_CLASSIFICATION, GROUP_ID, "mask_classification", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(maskDetection));
        MRL wordRotation = REPOSITORY.model(Application.CV.IMAGE_CLASSIFICATION, GROUP_ID, "word_rotation", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(wordRotation));
        MRL faceDetection = REPOSITORY.model(Application.CV.OBJECT_DETECTION, GROUP_ID, "face_detection", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(faceDetection));
        MRL wordDetection = REPOSITORY.model(Application.CV.OBJECT_DETECTION, GROUP_ID, "word_detection", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(wordDetection));
        MRL wordRecognition = REPOSITORY.model(Application.CV.WORD_RECOGNITION, GROUP_ID, "word_recognition", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(wordRecognition));
    }
}

