/*
 * Decompiled with CFR 0.152.
 */
package cn.torna.sdk.request;

import cn.torna.sdk.common.OpenConfig;
import cn.torna.sdk.common.RequestForm;
import cn.torna.sdk.response.BaseResponse;
import cn.torna.sdk.util.ClassUtil;
import cn.torna.sdk.util.JsonUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public abstract class BaseRequest<T extends BaseResponse<?>> {
    private static final String UTF8 = "UTF-8";
    @JSONField(serialize=false)
    private final String token;
    @JSONField(serialize=false)
    private final Class<T> responseClass = ClassUtil.getSuperClassGenricType(this.getClass(), 0);

    @JSONField(serialize=false)
    public abstract String name();

    public BaseRequest(String token) {
        this.token = token;
    }

    @JSONField(serialize=false)
    protected String version() {
        return OpenConfig.defaultVersion;
    }

    public RequestForm createRequestForm() {
        String data = this.buildJsonData();
        HashMap<String, String> param = new HashMap<String, String>();
        String name = this.name();
        if (name == null) {
            throw new IllegalArgumentException("name\u4e0d\u80fd\u4e3anull");
        }
        param.put(OpenConfig.apiName, name);
        param.put(OpenConfig.dataName, BaseRequest.encodeUrl(data));
        param.put(OpenConfig.timestampName, new SimpleDateFormat(OpenConfig.timestampPattern).format(new Date()));
        param.put(OpenConfig.versionName, this.version());
        param.put(OpenConfig.accessTokenName, this.token);
        return new RequestForm(param);
    }

    private static String encodeUrl(String input) {
        try {
            return URLEncoder.encode(input, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String buildJsonData() {
        return JSON.toJSONString((Object)this);
    }

    public T parseResponse(String resp) {
        return (T)((BaseResponse)JsonUtil.parseObject(resp, this.getResponseClass()));
    }

    private Class<T> getResponseClass() {
        return this.responseClass;
    }
}

