/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableConstaint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class MySqlCreateTableParser
extends SQLCreateTableParser {
    public MySqlCreateTableParser(String sql) {
        super(new MySqlExprParser(sql));
    }

    public MySqlCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCrateTable() {
        return this.parseCrateTable(true);
    }

    @Override
    public MySqlCreateTableStatement parseCrateTable(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        MySqlCreateTableStatement stmt = new MySqlCreateTableStatement();
        if (this.identifierEquals("TEMPORARY")) {
            this.lexer.nextToken();
            stmt.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExiists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token() == Token.IDENTIFIER) {
                    SQLColumnDefinition column = this.exprParser.parseColumn();
                    stmt.getTableElementList().add(column);
                } else if (this.lexer.token() == Token.CONSTRAINT) {
                    stmt.getTableElementList().add(this.parseConstraint());
                } else if (this.lexer.token() == Token.INDEX) {
                    this.lexer.nextToken();
                    MySqlTableIndex idx = new MySqlTableIndex();
                    if (this.lexer.token() == Token.IDENTIFIER && !"USING".equalsIgnoreCase(this.lexer.stringVal())) {
                        idx.setName(this.exprParser.name());
                    }
                    if (this.identifierEquals("USING")) {
                        this.lexer.nextToken();
                        idx.setIndexType(this.lexer.stringVal());
                        this.lexer.nextToken();
                    }
                    this.accept(Token.LPAREN);
                    while (true) {
                        idx.getColumns().add(this.exprParser.expr());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    stmt.getTableElementList().add(idx);
                } else if (this.lexer.token() == Token.KEY) {
                    stmt.getTableElementList().add(this.parseConstraint());
                } else if (this.lexer.token() == Token.PRIMARY) {
                    stmt.getTableElementList().add(this.parseConstraint());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        while (true) {
            if (this.identifierEquals("ENGINE")) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                stmt.getTableOptions().put("ENGINE", this.lexer.stringVal());
                this.lexer.nextToken();
                continue;
            }
            if (!this.identifierEquals("TYPE")) break;
            this.lexer.nextToken();
            this.accept(Token.EQ);
            stmt.getTableOptions().put("TYPE", this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.identifierEquals("PARTITION")) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token() == Token.KEY) {
                MySqlPartitionByKey clause = new MySqlPartitionByKey();
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    clause.getColumns().add(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                stmt.setPartitioning(clause);
                if (this.identifierEquals("PARTITIONS")) {
                    this.lexer.nextToken();
                    clause.setPartitionCount(this.exprParser.expr());
                }
            } else {
                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
        }
        if (this.lexer.token() == Token.ON) {
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.SELECT) {
            SQLSelect query = new MySqlSelectParser(this.exprParser).select();
            stmt.setQuery(query);
        }
        return stmt;
    }

    @Override
    protected SQLTableConstaint parseConstraint() {
        SQLName name = null;
        if (this.lexer.token() == Token.CONSTRAINT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            name = this.exprParser.name();
        }
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            MySqlKey key = new MySqlKey();
            if (this.identifierEquals("USING")) {
                this.lexer.nextToken();
                key.setIndexType(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            this.accept(Token.LPAREN);
            while (true) {
                key.getColumns().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            return key;
        }
        if (this.lexer.token() == Token.PRIMARY) {
            return (SQLTableConstaint)((Object)this.exprParser.parsePrimaryKey());
        }
        throw new ParserException("TODO");
    }
}

