/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBinaryExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBooleanExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExtractExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlIntervalExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlIntervalUnit;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlMatchAgainstExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlUserName;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class MySqlExprParser
extends SQLExprParser {
    public MySqlExprParser(Lexer lexer) {
        super(lexer);
    }

    public MySqlExprParser(String sql) {
        this(new MySqlLexer(sql));
        this.lexer.nextToken();
    }

    @Override
    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.identifierEquals("REGEXP")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.RegExp, rightExp);
        }
        if (this.identifierEquals("RLIKE")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.RegExp, rightExp);
        }
        return super.relationalRest(expr);
    }

    @Override
    public SQLExpr multiplicativeRest(SQLExpr expr) {
        if (this.lexer.token() == Token.IDENTIFIER && "MOD".equalsIgnoreCase(this.lexer.stringVal())) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.primary();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Modulus, rightExp);
        }
        return super.multiplicativeRest(expr);
    }

    @Override
    public SQLExpr notRationalRest(SQLExpr expr) {
        if (this.identifierEquals("REGEXP")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.primary();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotRegExp, rightExp);
        }
        if (this.identifierEquals("RLIKE")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.primary();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotRLike, rightExp);
        }
        return super.notRationalRest(expr);
    }

    @Override
    public SQLExpr primary() {
        Token tok = this.lexer.token();
        if (this.identifierEquals("outfile")) {
            this.lexer.nextToken();
            SQLExpr file = this.primary();
            MySqlOutFileExpr expr = new MySqlOutFileExpr(file);
            return this.primaryRest(expr);
        }
        switch (tok) {
            case TRUE: {
                this.lexer.nextToken();
                return this.primaryRest(new MySqlBooleanExpr(true));
            }
            case FALSE: {
                this.lexer.nextToken();
                return this.primaryRest(new MySqlBooleanExpr(false));
            }
            case LITERAL_ALIAS: {
                String aliasValue = this.lexer.stringVal();
                this.lexer.nextToken();
                return this.primaryRest(new SQLCharExpr(aliasValue));
            }
            case VARIANT: {
                SQLVariantRefExpr varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                if (varRefExpr.getName().equalsIgnoreCase("@@global")) {
                    this.accept(Token.DOT);
                    varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal(), true);
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                }
                return this.primaryRest(varRefExpr);
            }
            case VALUES: {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LPAREN) {
                    throw new ParserException("syntax error, illegal values clause");
                }
                return this.methodRest(new SQLIdentifierExpr("VALUES"), true);
            }
        }
        return super.primary();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final SQLExpr primaryRest(SQLExpr expr) {
        String ident;
        SQLIdentifierExpr identExpr;
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            if (expr instanceof SQLIdentifierExpr) {
                identExpr = (SQLIdentifierExpr)expr;
                ident = identExpr.getName();
                if (ident.equalsIgnoreCase("x")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new SQLHexExpr(charValue);
                    return this.primaryRest(expr);
                }
                if (ident.equalsIgnoreCase("b")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new MySqlBinaryExpr(charValue);
                    return this.primaryRest(expr);
                }
                if (ident.startsWith("_")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    MySqlCharExpr mysqlCharExpr = new MySqlCharExpr(charValue);
                    mysqlCharExpr.setCharset(identExpr.getName());
                    if (this.identifierEquals("COLLATE")) {
                        this.lexer.nextToken();
                        String collate = this.lexer.stringVal();
                        mysqlCharExpr.setCollate(collate);
                        this.accept(Token.IDENTIFIER);
                    }
                    expr = mysqlCharExpr;
                    return this.primaryRest(expr);
                }
                if (ident.equalsIgnoreCase("BINARY")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    MySqlCharExpr mysqlCharExpr = new MySqlCharExpr(charValue);
                    mysqlCharExpr.setCharset("BINARY");
                    expr = mysqlCharExpr;
                    return this.primaryRest(expr);
                }
            } else if (expr instanceof SQLCharExpr) {
                SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("CONCAT");
                concat.getParameters().add(expr);
                do {
                    String chars = this.lexer.stringVal();
                    concat.getParameters().add(new SQLCharExpr(chars));
                    this.lexer.nextToken();
                } while (this.lexer.token() == Token.LITERAL_CHARS);
                expr = concat;
            }
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            if (expr instanceof SQLHexExpr) {
                if ("USING".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("syntax error, illegal hex");
                    }
                    String charSet = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr.getAttributes().put("USING", charSet);
                    return this.primaryRest(expr);
                }
            } else {
                if ("COLLATE".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("syntax error");
                    }
                    String collate = this.lexer.stringVal();
                    this.lexer.nextToken();
                    SQLBinaryOpExpr binaryExpr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.COLLATE, new SQLIdentifierExpr(collate));
                    expr = binaryExpr;
                    return this.primaryRest(expr);
                }
                if (expr instanceof SQLVariantRefExpr) {
                    if ("COLLATE".equalsIgnoreCase(this.lexer.stringVal())) {
                        this.lexer.nextToken();
                        if (this.lexer.token() != Token.IDENTIFIER) {
                            throw new ParserException("syntax error");
                        }
                        String collate = this.lexer.stringVal();
                        this.lexer.nextToken();
                        expr.putAttribute("COLLATE", collate);
                        return this.primaryRest(expr);
                    }
                } else if (expr instanceof SQLIntegerExpr) {
                    SQLIntegerExpr intExpr = (SQLIntegerExpr)expr;
                    String binaryString = this.lexer.stringVal();
                    if (intExpr.getNumber().intValue() == 0 && binaryString.startsWith("b")) {
                        this.lexer.nextToken();
                        expr = new MySqlBinaryExpr(binaryString.substring(1));
                        return this.primaryRest(expr);
                    }
                }
            }
        }
        if (this.lexer.token() == Token.LPAREN && expr instanceof SQLIdentifierExpr) {
            identExpr = (SQLIdentifierExpr)expr;
            ident = identExpr.getName();
            if ("EXTRACT".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("syntax error");
                }
                String unitVal = this.lexer.stringVal();
                MySqlIntervalUnit unit = MySqlIntervalUnit.valueOf(unitVal);
                this.lexer.nextToken();
                this.accept(Token.FROM);
                SQLExpr value = this.expr();
                MySqlExtractExpr extract = new MySqlExtractExpr();
                extract.setValue(value);
                extract.setUnit(unit);
                this.accept(Token.RPAREN);
                expr = extract;
                return this.primaryRest(expr);
            }
            if ("SUBSTRING".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(ident);
                while (true) {
                    SQLExpr param = this.expr();
                    methodInvokeExpr.getParameters().add(param);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    SQLExpr from = this.expr();
                    methodInvokeExpr.putAttribute("FROM", from);
                    if (this.lexer.token() == Token.FOR) {
                        this.lexer.nextToken();
                        SQLExpr forExpr = this.expr();
                        methodInvokeExpr.putAttribute("FOR", forExpr);
                    }
                } else if (this.lexer.token() != Token.RPAREN) {
                    throw new ParserException("syntax error");
                }
                this.accept(Token.RPAREN);
                expr = methodInvokeExpr;
                return this.primaryRest(expr);
            }
            if ("TRIM".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(ident);
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String flagVal = this.lexer.stringVal();
                    if ("LEADING".equalsIgnoreCase(flagVal)) {
                        this.lexer.nextToken();
                        methodInvokeExpr.getAttributes().put("TRIM_TYPE", "LEADING");
                    } else if ("BOTH".equalsIgnoreCase(flagVal)) {
                        this.lexer.nextToken();
                        methodInvokeExpr.getAttributes().put("TRIM_TYPE", "BOTH");
                    } else if ("TRAILING".equalsIgnoreCase(flagVal)) {
                        this.lexer.nextToken();
                        methodInvokeExpr.putAttribute("TRIM_TYPE", "TRAILING");
                    }
                }
                SQLExpr param = this.expr();
                methodInvokeExpr.getParameters().add(param);
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    SQLExpr from = this.expr();
                    methodInvokeExpr.putAttribute("FROM", from);
                }
                this.accept(Token.RPAREN);
                expr = methodInvokeExpr;
                return this.primaryRest(expr);
            }
            if ("MATCH".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                MySqlMatchAgainstExpr matchAgainstExpr = new MySqlMatchAgainstExpr();
                if (this.lexer.token() == Token.RPAREN) {
                    this.lexer.nextToken();
                } else {
                    this.exprList(matchAgainstExpr.getColumns());
                    this.accept(Token.RPAREN);
                }
                this.acceptIdentifier("AGAINST");
                this.accept(Token.LPAREN);
                SQLExpr against = this.primary();
                matchAgainstExpr.setAgainst(against);
                if (this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    if (!this.identifierEquals("NATURAL")) throw new ParserException("TODO");
                    this.lexer.nextToken();
                    this.acceptIdentifier("LANGUAGE");
                    this.acceptIdentifier("MODE");
                    if (this.identifierEquals("WITH")) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("QUERY");
                        this.acceptIdentifier("EXPANSION");
                        matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_NATURAL_LANGUAGE_MODE_WITH_QUERY_EXPANSION);
                    } else {
                        matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_NATURAL_LANGUAGE_MODE);
                    }
                } else if (this.identifierEquals("WITH")) {
                    throw new ParserException("TODO");
                }
                this.accept(Token.RPAREN);
                expr = matchAgainstExpr;
                return this.primaryRest(expr);
            }
            if ("CONVERT".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(ident);
                if (this.lexer.token() != Token.RPAREN) {
                    this.exprList(methodInvokeExpr.getParameters());
                }
                if (this.identifierEquals("USING")) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("syntax error");
                    }
                    String charset = this.lexer.stringVal();
                    this.lexer.nextToken();
                    methodInvokeExpr.putAttribute("USING", charset);
                }
                this.accept(Token.RPAREN);
                expr = methodInvokeExpr;
                return this.primaryRest(expr);
            }
        }
        if (this.lexer.token() != Token.VARIANT || !"@".equals(this.lexer.stringVal())) return super.primaryRest(expr);
        this.lexer.nextToken();
        MySqlUserName userName = new MySqlUserName();
        if (expr instanceof SQLCharExpr) {
            userName.setUserName(((SQLCharExpr)expr).toString());
        } else {
            userName.setUserName(((SQLIdentifierExpr)expr).getName());
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            userName.setHost("'" + this.lexer.stringVal() + "'");
        } else {
            userName.setHost(this.lexer.stringVal());
        }
        this.lexer.nextToken();
        return userName;
    }

    @Override
    public SQLSelectParser createSelectParser() {
        return new MySqlSelectParser(this);
    }

    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("INTERVAL");
            if (this.lexer.token() != Token.RPAREN) {
                this.exprList(methodInvokeExpr.getParameters());
            }
            this.accept(Token.RPAREN);
            return this.primaryRest(methodInvokeExpr);
        }
        SQLExpr value = this.expr();
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("Syntax error");
        }
        String unit = this.lexer.stringVal();
        this.lexer.nextToken();
        MySqlIntervalExpr intervalExpr = new MySqlIntervalExpr();
        intervalExpr.setValue(value);
        intervalExpr.setUnit(MySqlIntervalUnit.valueOf(unit.toUpperCase()));
        return intervalExpr;
    }

    @Override
    public SQLColumnDefinition parseColumn() {
        MySqlSQLColumnDefinition column = new MySqlSQLColumnDefinition();
        column.setName(this.name());
        column.setDataType(this.parseDataType());
        return this.parseColumnRest(column);
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.identifierEquals("AUTO_INCREMENT")) {
            this.lexer.nextToken();
            if (column instanceof MySqlSQLColumnDefinition) {
                ((MySqlSQLColumnDefinition)column).setAutoIncrement(true);
            }
            return this.parseColumnRest(column);
        }
        if (this.identifierEquals("PARTITION")) {
            throw new ParserException("syntax error " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        super.parseColumnRest(column);
        return column;
    }

    @Override
    public SQLExpr orRest(SQLExpr expr) {
        while (true) {
            SQLExpr rightExp;
            if (this.lexer.token() == Token.OR || this.lexer.token() == Token.BARBAR) {
                this.lexer.nextToken();
                rightExp = this.and();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanOr, rightExp);
                continue;
            }
            if (this.lexer.token() != Token.XOR) break;
            this.lexer.nextToken();
            rightExp = this.and();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanXor, rightExp);
        }
        return expr;
    }

    @Override
    public SQLAssignItem parseAssignItem() {
        SQLAssignItem item = new SQLAssignItem();
        SQLExpr var = this.primary();
        if (var instanceof SQLIdentifierExpr) {
            String ident = ((SQLIdentifierExpr)var).getName();
            if ("GLOBAL".equalsIgnoreCase(ident)) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, true);
            } else if ("SESSION".equalsIgnoreCase(ident)) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, false);
            } else {
                var = new SQLVariantRefExpr(ident);
            }
        }
        item.setTarget(var);
        if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.EQ);
        }
        item.setValue(this.expr());
        return item;
    }

    @Override
    public SQLName nameRest(SQLName name) {
        if (this.lexer.token() == Token.VARIANT && "@".equals(this.lexer.stringVal())) {
            this.lexer.nextToken();
            MySqlUserName userName = new MySqlUserName();
            userName.setUserName(((SQLIdentifierExpr)name).getName());
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                userName.setHost("'" + this.lexer.stringVal() + "'");
            } else {
                userName.setHost(this.lexer.stringVal());
            }
            this.lexer.nextToken();
            return userName;
        }
        return super.nameRest(name);
    }

    public MySqlSelectQueryBlock.Limit parseLimit() {
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            MySqlSelectQueryBlock.Limit limit = new MySqlSelectQueryBlock.Limit();
            SQLExpr temp = this.expr();
            if (this.lexer.token() == Token.COMMA) {
                limit.setOffset(temp);
                this.lexer.nextToken();
                limit.setRowCount(this.expr());
            } else if (this.identifierEquals("OFFSET")) {
                limit.setRowCount(temp);
                this.lexer.nextToken();
                limit.setOffset(this.expr());
            } else {
                limit.setRowCount(temp);
            }
            return limit;
        }
        return null;
    }

    @Override
    public SQLPrimaryKey parsePrimaryKey() {
        this.accept(Token.PRIMARY);
        this.accept(Token.KEY);
        MySqlPrimaryKey primaryKey = new MySqlPrimaryKey();
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            primaryKey.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        this.accept(Token.LPAREN);
        while (true) {
            primaryKey.getColumns().add(this.expr());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return primaryKey;
    }
}

