/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractManager<T extends ExpressionModifier> {
    protected final ResolvingQueryGenerator queryGenerator;
    protected final ParameterManager parameterManager;
    protected final SubqueryInitiatorFactory subqueryInitFactory;

    protected AbstractManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory) {
        this.queryGenerator = queryGenerator;
        this.parameterManager = parameterManager;
        this.subqueryInitFactory = subqueryInitFactory;
    }

    protected void registerParameterExpressions(Expression expression) {
        this.parameterManager.collectParameterRegistrations(expression, this.getClauseType(), this.subqueryInitFactory.getQueryBuilder());
    }

    protected void unregisterParameterExpressions(Expression expression) {
        this.parameterManager.collectParameterUnregistrations(expression, this.getClauseType(), this.subqueryInitFactory.getQueryBuilder());
    }

    protected void build(StringBuilder sb, Set<String> clauses) {
        Iterator<String> iter = clauses.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next());
        }
        while (iter.hasNext()) {
            sb.append(", ");
            sb.append(iter.next());
        }
    }

    public abstract void apply(ExpressionModifierVisitor<? super T> var1);

    public abstract ClauseType getClauseType();
}

