/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.JpqlMacroStorage;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.MacroConfiguration;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.List;
import java.util.Set;

public final class JpqlMacroAwareExpressionFactory
implements ExpressionFactory {
    private final ExpressionFactory expressionFactory;
    private final JpqlMacroStorage macroStorage;

    public JpqlMacroAwareExpressionFactory(ExpressionFactory expressionFactory, JpqlMacroStorage macroStorage) {
        this.expressionFactory = expressionFactory;
        this.macroStorage = macroStorage;
    }

    public <T extends ExpressionFactory> T unwrap(Class<T> clazz) {
        if (JpqlMacroAwareExpressionFactory.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        return (T)this.expressionFactory.unwrap(clazz);
    }

    public MacroConfiguration getDefaultMacroConfiguration() {
        return this.macroStorage.getMacroConfiguration();
    }

    public Expression createJoinPathExpression(String expression) {
        return this.createJoinPathExpression(expression, this.getDefaultMacroConfiguration(), null);
    }

    public Expression createJoinPathExpression(String expression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        Expression pathExpression = this.createPathExpression(expression, macroConfiguration, usedMacros);
        if (pathExpression instanceof PathExpression) {
            PathElementExpression first;
            List expressions = ((PathExpression)pathExpression).getExpressions();
            if (expressions.size() > 1 || (first = (PathElementExpression)expressions.get(0)) instanceof PropertyExpression || first instanceof ArrayExpression) {
                return pathExpression;
            }
            return first;
        }
        return pathExpression;
    }

    public PathExpression createPathExpression(String expression) {
        return (PathExpression)this.expressionFactory.createPathExpression(expression, this.getDefaultMacroConfiguration(), null);
    }

    public Expression createPathExpression(String expression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.expressionFactory.createPathExpression(expression, macroConfiguration, usedMacros);
    }

    public Expression createSimpleExpression(String expression) {
        return this.expressionFactory.createSimpleExpression(expression, false, false, false, this.getDefaultMacroConfiguration(), null);
    }

    public Expression createSimpleExpression(String expression, boolean allowQuantifiedPredicates) {
        return this.expressionFactory.createSimpleExpression(expression, false, allowQuantifiedPredicates, false, this.getDefaultMacroConfiguration(), null);
    }

    public Expression createSimpleExpression(String expression, boolean allowOuter, boolean allowQuantifiedPredicates) {
        return this.expressionFactory.createSimpleExpression(expression, allowOuter, allowQuantifiedPredicates, false, this.getDefaultMacroConfiguration(), null);
    }

    public Expression createSimpleExpression(String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression) {
        return this.expressionFactory.createSimpleExpression(expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression, this.getDefaultMacroConfiguration(), null);
    }

    public Expression createSimpleExpression(String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.expressionFactory.createSimpleExpression(expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression, macroConfiguration, usedMacros);
    }

    public List<Expression> createInItemExpressions(String[] parameterOrLiteralExpressions) {
        return this.expressionFactory.createInItemExpressions(parameterOrLiteralExpressions, this.getDefaultMacroConfiguration(), null);
    }

    public List<Expression> createInItemExpressions(String[] parameterOrLiteralExpressions, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.expressionFactory.createInItemExpressions(parameterOrLiteralExpressions, macroConfiguration, usedMacros);
    }

    public Expression createInItemExpression(String parameterOrLiteralExpression) {
        return this.expressionFactory.createInItemExpression(parameterOrLiteralExpression, this.getDefaultMacroConfiguration(), null);
    }

    public Expression createInItemExpression(String parameterOrLiteralExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.expressionFactory.createInItemExpression(parameterOrLiteralExpression, macroConfiguration, usedMacros);
    }

    public Expression createInItemOrPathExpression(String parameterOrLiteralExpression) {
        return this.expressionFactory.createInItemOrPathExpression(parameterOrLiteralExpression, this.getDefaultMacroConfiguration(), null);
    }

    public Expression createInItemOrPathExpression(String parameterOrLiteralExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.expressionFactory.createInItemOrPathExpression(parameterOrLiteralExpression, macroConfiguration, usedMacros);
    }

    public Predicate createBooleanExpression(String expression, boolean allowQuantifiedPredicates) {
        return this.expressionFactory.createBooleanExpression(expression, allowQuantifiedPredicates, this.getDefaultMacroConfiguration(), null);
    }

    public Predicate createBooleanExpression(String expression, boolean allowQuantifiedPredicates, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.expressionFactory.createBooleanExpression(expression, allowQuantifiedPredicates, macroConfiguration, usedMacros);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExpressionFactory) {
            ExpressionFactory that = (ExpressionFactory)o;
            ExpressionFactory thatExpressionFactory = that.unwrap(this.expressionFactory.getClass());
            if (thatExpressionFactory == null || !this.expressionFactory.equals(thatExpressionFactory)) {
                return false;
            }
            return this.getDefaultMacroConfiguration() != null ? this.getDefaultMacroConfiguration().equals((Object)that.getDefaultMacroConfiguration()) : that.getDefaultMacroConfiguration() == null;
        }
        return false;
    }

    public int hashCode() {
        int result = this.expressionFactory != null ? this.expressionFactory.hashCode() : 0;
        result = 31 * result + (this.getDefaultMacroConfiguration() != null ? this.getDefaultMacroConfiguration().hashCode() : 0);
        return result;
    }
}

