/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.EscapeBuilder;
import com.blazebit.persistence.impl.BuilderChainingException;

public class EscapeBuilderImpl<T>
implements EscapeBuilder<T> {
    private final EscapeBuilderImplEndedListener listener;
    private final T result;
    private Character escapeCharacter;

    public EscapeBuilderImpl(EscapeBuilderImplEndedListener listener, T result) {
        this.listener = listener;
        this.result = result;
    }

    public T escape(char c) {
        this.escapeCharacter = Character.valueOf(c);
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T noEscape() {
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public static class EscapeBuilderImplEndedListener {
        private EscapeBuilderImpl<?> currentBuilder;

        public void verifyBuilderEnded() {
            if (this.currentBuilder != null) {
                throw new BuilderChainingException("A builder was not ended properly.");
            }
        }

        public <T extends EscapeBuilderImpl<?>> T startBuilder(T builder) {
            if (this.currentBuilder != null) {
                throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
            }
            this.currentBuilder = builder;
            return builder;
        }

        public void onBuilderEnded(EscapeBuilderImpl<?> builder) {
            if (this.currentBuilder == null) {
                throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
            }
            this.currentBuilder = null;
        }
    }
}

