/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.spi.DbmsLimitHandler;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class AbstractDbmsLimitHandler
implements DbmsLimitHandler {
    private final int length;

    public AbstractDbmsLimitHandler(int length) {
        this.length = length;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean limitIncludesOffset() {
        return false;
    }

    protected abstract boolean supportsVariableLimit();

    public String applySql(String sql, boolean isSubquery, Integer limit, Integer offset) {
        if (limit == null && offset == null) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(sql.length() + this.length);
        sb.append(sql);
        if (this.supportsVariableLimit()) {
            this.applySql(sb, isSubquery, limit == null ? null : "?", offset == null ? null : "?");
        } else if (this.limitIncludesOffset() && offset != null && limit != null) {
            this.applySql(sb, isSubquery, Integer.toString(limit + offset), offset.toString());
        } else {
            this.applySql(sb, isSubquery, limit == null ? null : limit.toString(), offset == null ? null : offset.toString());
        }
        return sb.toString();
    }

    public String applySqlInlined(String sql, boolean isSubquery, Integer limit, Integer offset) {
        if (limit == null && offset == null) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(sql.length() + this.length);
        sb.append(sql);
        if (this.limitIncludesOffset() && offset != null && limit != null) {
            this.applySql(sb, isSubquery, Integer.toString(limit + offset), offset.toString());
        } else {
            this.applySql(sb, isSubquery, limit == null ? null : limit.toString(), offset == null ? null : offset.toString());
        }
        return sb.toString();
    }

    public int bindLimitParametersAtStartOfQuery(Integer limit, Integer offset, PreparedStatement statement, int index) throws SQLException {
        return 0;
    }

    public void setMaxRows(Integer limit, Integer offset, PreparedStatement statement) throws SQLException {
    }
}

