/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.keyset;

import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import java.io.Serializable;

public class KeysetPaginationHelper {
    private KeysetPaginationHelper() {
    }

    public static Serializable[] extractKey(Object[] tuple, int[] mapping, int suffixLength) {
        Serializable[] key = new Serializable[mapping.length];
        int suffixIndex = tuple.length - suffixLength;
        for (int i = 0; i < mapping.length; ++i) {
            int index = mapping[i];
            key[i] = index == -1 ? (Serializable)tuple[suffixIndex++] : (Serializable)tuple[index];
        }
        return key;
    }

    public static KeysetMode getKeysetMode(KeysetPage keysetPage, Object entityId, int firstRow, int pageSize) {
        if (keysetPage == null) {
            return KeysetMode.NONE;
        }
        if (entityId != null) {
            return KeysetMode.NONE;
        }
        if (firstRow == 0) {
            return KeysetMode.NONE;
        }
        int offset = keysetPage.getFirstResult() - firstRow;
        int keysetPageSize = keysetPage.getMaxResults();
        if (offset > 0 && offset <= keysetPageSize) {
            if (KeysetPaginationHelper.isValidKey(keysetPage.getLowest())) {
                return KeysetMode.PREVIOUS;
            }
            return KeysetMode.NONE;
        }
        if (offset < 0 && -offset <= keysetPageSize) {
            if (KeysetPaginationHelper.isValidKey(keysetPage.getHighest())) {
                return KeysetMode.NEXT;
            }
            return KeysetMode.NONE;
        }
        if (offset == 0) {
            if (KeysetPaginationHelper.isValidKey(keysetPage.getLowest())) {
                return KeysetMode.SAME;
            }
            return KeysetMode.NONE;
        }
        return KeysetMode.NONE;
    }

    private static boolean isValidKey(Keyset keyset) {
        if (keyset == null) {
            return false;
        }
        Serializable[] key = keyset.getTuple();
        return key != null && key.length > 0;
    }
}

