/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Blazebit
 */

package com.blazebit.persistence.view;

import javax.persistence.EntityManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to mark a method to be executed before removing an entity view due to orphan removal, delete cascading or removal.
 * A method annotated with <code>@PreRemove</code> may optionally have the following parameters
 * <ul>
 *     <li>An {@link EntityViewManager}</li>
 *     <li>An {@link EntityManager}</li>
 * </ul>
 * There may only be one method in a class annotated with <code>@PreRemove</code> and it may return <code>boolean</code> or <code>void</code>.
 * If it declares a <code>boolean</code> return type, returning <code>true</code> will cause the removal operation to be done and
 * returning <code>false</code> will cause the removal operation to be cancelled.
 * Super type methods annotated with <code>@PreRemove</code> are ignored if an entity view defines a <code>@PreRemove</code> method.
 *
 * @author Christian Beikov
 * @since 1.4.0
 */
@Target({ ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface PreRemove {
}
