/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis;

import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import java.util.Objects;

public class AbstractRedisProxyManagerBuilder<T extends AbstractRedisProxyManagerBuilder> {
    private ExpirationAfterWriteStrategy expirationStrategy;
    private ClientSideConfig clientSideConfig = ClientSideConfig.getDefault();

    public T withExpirationStrategy(ExpirationAfterWriteStrategy expirationStrategy) {
        this.expirationStrategy = Objects.requireNonNull(expirationStrategy);
        return (T)this;
    }

    public T withClientSideConfig(ClientSideConfig clientSideConfig) {
        this.clientSideConfig = Objects.requireNonNull(clientSideConfig);
        return (T)this;
    }

    public ExpirationAfterWriteStrategy getNotNullExpirationStrategy() {
        if (this.expirationStrategy == null) {
            throw new IllegalStateException("expirationStrategy is not configured");
        }
        return this.expirationStrategy;
    }

    public ClientSideConfig getClientSideConfig() {
        return this.clientSideConfig;
    }
}

