/* Copyright 2013 Samuel Halliday (generated Java and C).
 * Copyright 2003-2007 Keith Seymour (Fortran to Java translation).
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 *
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.github.fommil.netlib;

/**
 * Generated by {@code NativeImplJavaGenerator} from {@code org.netlib.blas} in {@code net.sourceforge.f2j:arpack_combined_all:jar:0.1}.
 */
public class NativeRefBLAS extends com.github.fommil.netlib.F2jBLAS {
  static {
    String jnilib = com.github.fommil.jni.JniNamer.getJniName("netlib-native_ref");
    String natives = System.getProperty("com.github.fommil.netlib.NativeRefBLAS.natives", jnilib);
    com.github.fommil.jni.JniLoader.load(natives.split(","));
  }

  @Override
  public native double dasum(int n, double[] dx, int incx);

  @Override
  public double dasum(int n, double[] dx, int _dx_offset, int incx) {
    return dasum_offsets(n, dx, _dx_offset, incx);
  }

  public native double dasum_offsets(int n, double[] dx, int _dx_offset, int incx);

  @Override
  public native void daxpy(int n, double da, double[] dx, int incx, double[] dy, int incy);

  @Override
  public void daxpy(int n, double da, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy) {
  daxpy_offsets(n, da, dx, _dx_offset, incx, dy, _dy_offset, incy);
  }

  public native void daxpy_offsets(int n, double da, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy);

  @Override
  public native void dcopy(int n, double[] dx, int incx, double[] dy, int incy);

  @Override
  public void dcopy(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy) {
  dcopy_offsets(n, dx, _dx_offset, incx, dy, _dy_offset, incy);
  }

  public native void dcopy_offsets(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy);

  @Override
  public native double ddot(int n, double[] dx, int incx, double[] dy, int incy);

  @Override
  public double ddot(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy) {
    return ddot_offsets(n, dx, _dx_offset, incx, dy, _dy_offset, incy);
  }

  public native double ddot_offsets(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy);

  @Override
  public native void dgbmv(java.lang.String trans, int m, int n, int kl, int ku, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy);

  @Override
  public void dgbmv(java.lang.String trans, int m, int n, int kl, int ku, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy) {
  dgbmv_offsets(trans, m, n, kl, ku, alpha, a, _a_offset, lda, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void dgbmv_offsets(java.lang.String trans, int m, int n, int kl, int ku, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  @Override
  public native void dgemm(java.lang.String transa, java.lang.String transb, int m, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc);

  @Override
  public void dgemm(java.lang.String transa, java.lang.String transb, int m, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc) {
  dgemm_offsets(transa, transb, m, n, k, alpha, a, _a_offset, lda, b, _b_offset, ldb, beta, c, _c_offset, Ldc);
  }

  public native void dgemm_offsets(java.lang.String transa, java.lang.String transb, int m, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc);

  @Override
  public native void dgemv(java.lang.String trans, int m, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy);

  @Override
  public void dgemv(java.lang.String trans, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy) {
  dgemv_offsets(trans, m, n, alpha, a, _a_offset, lda, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void dgemv_offsets(java.lang.String trans, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  @Override
  public native void dger(int m, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda);

  @Override
  public void dger(int m, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] a, int _a_offset, int lda) {
  dger_offsets(m, n, alpha, x, _x_offset, incx, y, _y_offset, incy, a, _a_offset, lda);
  }

  public native void dger_offsets(int m, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] a, int _a_offset, int lda);

  @Override
  public native double dnrm2(int n, double[] x, int incx);

  @Override
  public double dnrm2(int n, double[] x, int _x_offset, int incx) {
    return dnrm2_offsets(n, x, _x_offset, incx);
  }

  public native double dnrm2_offsets(int n, double[] x, int _x_offset, int incx);

  @Override
  public native void drot(int n, double[] dx, int incx, double[] dy, int incy, double c, double s);

  @Override
  public void drot(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy, double c, double s) {
  drot_offsets(n, dx, _dx_offset, incx, dy, _dy_offset, incy, c, s);
  }

  public native void drot_offsets(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy, double c, double s);

  @Override
  public native void drotg(org.netlib.util.doubleW da, org.netlib.util.doubleW db, org.netlib.util.doubleW c, org.netlib.util.doubleW s);

  @Override
  public native void drotm(int n, double[] dx, int incx, double[] dy, int incy, double[] dparam);

  @Override
  public void drotm(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy, double[] dparam, int _dparam_offset) {
  drotm_offsets(n, dx, _dx_offset, incx, dy, _dy_offset, incy, dparam, _dparam_offset);
  }

  public native void drotm_offsets(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy, double[] dparam, int _dparam_offset);

  @Override
  public native void drotmg(org.netlib.util.doubleW dd1, org.netlib.util.doubleW dd2, org.netlib.util.doubleW dx1, double dy1, double[] dparam);

  @Override
  public void drotmg(org.netlib.util.doubleW dd1, org.netlib.util.doubleW dd2, org.netlib.util.doubleW dx1, double dy1, double[] dparam, int _dparam_offset) {
  drotmg_offsets(dd1, dd2, dx1, dy1, dparam, _dparam_offset);
  }

  public native void drotmg_offsets(org.netlib.util.doubleW dd1, org.netlib.util.doubleW dd2, org.netlib.util.doubleW dx1, double dy1, double[] dparam, int _dparam_offset);

  @Override
  public native void dsbmv(java.lang.String uplo, int n, int k, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy);

  @Override
  public void dsbmv(java.lang.String uplo, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy) {
  dsbmv_offsets(uplo, n, k, alpha, a, _a_offset, lda, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void dsbmv_offsets(java.lang.String uplo, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  @Override
  public native void dscal(int n, double da, double[] dx, int incx);

  @Override
  public void dscal(int n, double da, double[] dx, int _dx_offset, int incx) {
  dscal_offsets(n, da, dx, _dx_offset, incx);
  }

  public native void dscal_offsets(int n, double da, double[] dx, int _dx_offset, int incx);

  @Override
  public native void dspmv(java.lang.String uplo, int n, double alpha, double[] ap, double[] x, int incx, double beta, double[] y, int incy);

  @Override
  public void dspmv(java.lang.String uplo, int n, double alpha, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy) {
  dspmv_offsets(uplo, n, alpha, ap, _ap_offset, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void dspmv_offsets(java.lang.String uplo, int n, double alpha, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  @Override
  public native void dspr(java.lang.String uplo, int n, double alpha, double[] x, int incx, double[] ap);

  @Override
  public void dspr(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] ap, int _ap_offset) {
  dspr_offsets(uplo, n, alpha, x, _x_offset, incx, ap, _ap_offset);
  }

  public native void dspr_offsets(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] ap, int _ap_offset);

  @Override
  public native void dspr2(java.lang.String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] ap);

  @Override
  public void dspr2(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] ap, int _ap_offset) {
  dspr2_offsets(uplo, n, alpha, x, _x_offset, incx, y, _y_offset, incy, ap, _ap_offset);
  }

  public native void dspr2_offsets(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] ap, int _ap_offset);

  @Override
  public native void dswap(int n, double[] dx, int incx, double[] dy, int incy);

  @Override
  public void dswap(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy) {
  dswap_offsets(n, dx, _dx_offset, incx, dy, _dy_offset, incy);
  }

  public native void dswap_offsets(int n, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy);

  @Override
  public native void dsymm(java.lang.String side, java.lang.String uplo, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc);

  @Override
  public void dsymm(java.lang.String side, java.lang.String uplo, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc) {
  dsymm_offsets(side, uplo, m, n, alpha, a, _a_offset, lda, b, _b_offset, ldb, beta, c, _c_offset, Ldc);
  }

  public native void dsymm_offsets(java.lang.String side, java.lang.String uplo, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc);

  @Override
  public native void dsymv(java.lang.String uplo, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy);

  @Override
  public void dsymv(java.lang.String uplo, int n, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy) {
  dsymv_offsets(uplo, n, alpha, a, _a_offset, lda, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void dsymv_offsets(java.lang.String uplo, int n, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy);

  @Override
  public native void dsyr(java.lang.String uplo, int n, double alpha, double[] x, int incx, double[] a, int lda);

  @Override
  public void dsyr(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] a, int _a_offset, int lda) {
  dsyr_offsets(uplo, n, alpha, x, _x_offset, incx, a, _a_offset, lda);
  }

  public native void dsyr_offsets(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] a, int _a_offset, int lda);

  @Override
  public native void dsyr2(java.lang.String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda);

  @Override
  public void dsyr2(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] a, int _a_offset, int lda) {
  dsyr2_offsets(uplo, n, alpha, x, _x_offset, incx, y, _y_offset, incy, a, _a_offset, lda);
  }

  public native void dsyr2_offsets(java.lang.String uplo, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] a, int _a_offset, int lda);

  @Override
  public native void dsyr2k(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int Ldc);

  @Override
  public void dsyr2k(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc) {
  dsyr2k_offsets(uplo, trans, n, k, alpha, a, _a_offset, lda, b, _b_offset, ldb, beta, c, _c_offset, Ldc);
  }

  public native void dsyr2k_offsets(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int Ldc);

  @Override
  public native void dsyrk(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int lda, double beta, double[] c, int Ldc);

  @Override
  public void dsyrk(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int _a_offset, int lda, double beta, double[] c, int _c_offset, int Ldc) {
  dsyrk_offsets(uplo, trans, n, k, alpha, a, _a_offset, lda, beta, c, _c_offset, Ldc);
  }

  public native void dsyrk_offsets(java.lang.String uplo, java.lang.String trans, int n, int k, double alpha, double[] a, int _a_offset, int lda, double beta, double[] c, int _c_offset, int Ldc);

  @Override
  public native void dtbmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int lda, double[] x, int incx);

  @Override
  public void dtbmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx) {
  dtbmv_offsets(uplo, trans, diag, n, k, a, _a_offset, lda, x, _x_offset, incx);
  }

  public native void dtbmv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx);

  @Override
  public native void dtbsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int lda, double[] x, int incx);

  @Override
  public void dtbsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx) {
  dtbsv_offsets(uplo, trans, diag, n, k, a, _a_offset, lda, x, _x_offset, incx);
  }

  public native void dtbsv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx);

  @Override
  public native void dtpmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, double[] x, int incx);

  @Override
  public void dtpmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx) {
  dtpmv_offsets(uplo, trans, diag, n, ap, _ap_offset, x, _x_offset, incx);
  }

  public native void dtpmv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx);

  @Override
  public native void dtpsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, double[] x, int incx);

  @Override
  public void dtpsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx) {
  dtpsv_offsets(uplo, trans, diag, n, ap, _ap_offset, x, _x_offset, incx);
  }

  public native void dtpsv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] ap, int _ap_offset, double[] x, int _x_offset, int incx);

  @Override
  public native void dtrmm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb);

  @Override
  public void dtrmm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb) {
  dtrmm_offsets(side, uplo, transa, diag, m, n, alpha, a, _a_offset, lda, b, _b_offset, ldb);
  }

  public native void dtrmm_offsets(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb);

  @Override
  public native void dtrmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int lda, double[] x, int incx);

  @Override
  public void dtrmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx) {
  dtrmv_offsets(uplo, trans, diag, n, a, _a_offset, lda, x, _x_offset, incx);
  }

  public native void dtrmv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx);

  @Override
  public native void dtrsm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb);

  @Override
  public void dtrsm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb) {
  dtrsm_offsets(side, uplo, transa, diag, m, n, alpha, a, _a_offset, lda, b, _b_offset, ldb);
  }

  public native void dtrsm_offsets(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb);

  @Override
  public native void dtrsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int lda, double[] x, int incx);

  @Override
  public void dtrsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx) {
  dtrsv_offsets(uplo, trans, diag, n, a, _a_offset, lda, x, _x_offset, incx);
  }

  public native void dtrsv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx);

  @Override
  public native int idamax(int n, double[] dx, int incx);

  @Override
  public int idamax(int n, double[] dx, int _dx_offset, int incx) {
    return idamax_offsets(n, dx, _dx_offset, incx);
  }

  public native int idamax_offsets(int n, double[] dx, int _dx_offset, int incx);

  @Override
  public native int isamax(int n, float[] sx, int incx);

  @Override
  public int isamax(int n, float[] sx, int _sx_offset, int incx) {
    return isamax_offsets(n, sx, _sx_offset, incx);
  }

  public native int isamax_offsets(int n, float[] sx, int _sx_offset, int incx);

  @Override
  public native float sasum(int n, float[] sx, int incx);

  @Override
  public float sasum(int n, float[] sx, int _sx_offset, int incx) {
    return sasum_offsets(n, sx, _sx_offset, incx);
  }

  public native float sasum_offsets(int n, float[] sx, int _sx_offset, int incx);

  @Override
  public native void saxpy(int n, float sa, float[] sx, int incx, float[] sy, int incy);

  @Override
  public void saxpy(int n, float sa, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy) {
  saxpy_offsets(n, sa, sx, _sx_offset, incx, sy, _sy_offset, incy);
  }

  public native void saxpy_offsets(int n, float sa, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  @Override
  public native void scopy(int n, float[] sx, int incx, float[] sy, int incy);

  @Override
  public void scopy(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy) {
  scopy_offsets(n, sx, _sx_offset, incx, sy, _sy_offset, incy);
  }

  public native void scopy_offsets(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  @Override
  public native float sdot(int n, float[] sx, int incx, float[] sy, int incy);

  @Override
  public float sdot(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy) {
    return sdot_offsets(n, sx, _sx_offset, incx, sy, _sy_offset, incy);
  }

  public native float sdot_offsets(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  @Override
  public native float sdsdot(int n, float sb, float[] sx, int incx, float[] sy, int incy);

  @Override
  public float sdsdot(int n, float sb, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy) {
    return sdsdot_offsets(n, sb, sx, _sx_offset, incx, sy, _sy_offset, incy);
  }

  public native float sdsdot_offsets(int n, float sb, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  @Override
  public native void sgbmv(java.lang.String trans, int m, int n, int kl, int ku, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy);

  @Override
  public void sgbmv(java.lang.String trans, int m, int n, int kl, int ku, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy) {
  sgbmv_offsets(trans, m, n, kl, ku, alpha, a, _a_offset, lda, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void sgbmv_offsets(java.lang.String trans, int m, int n, int kl, int ku, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  @Override
  public native void sgemm(java.lang.String transa, java.lang.String transb, int m, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc);

  @Override
  public void sgemm(java.lang.String transa, java.lang.String transb, int m, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc) {
  sgemm_offsets(transa, transb, m, n, k, alpha, a, _a_offset, lda, b, _b_offset, ldb, beta, c, _c_offset, Ldc);
  }

  public native void sgemm_offsets(java.lang.String transa, java.lang.String transb, int m, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc);

  @Override
  public native void sgemv(java.lang.String trans, int m, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy);

  @Override
  public void sgemv(java.lang.String trans, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy) {
  sgemv_offsets(trans, m, n, alpha, a, _a_offset, lda, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void sgemv_offsets(java.lang.String trans, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  @Override
  public native void sger(int m, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a, int lda);

  @Override
  public void sger(int m, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] a, int _a_offset, int lda) {
  sger_offsets(m, n, alpha, x, _x_offset, incx, y, _y_offset, incy, a, _a_offset, lda);
  }

  public native void sger_offsets(int m, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] a, int _a_offset, int lda);

  @Override
  public native float snrm2(int n, float[] x, int incx);

  @Override
  public float snrm2(int n, float[] x, int _x_offset, int incx) {
    return snrm2_offsets(n, x, _x_offset, incx);
  }

  public native float snrm2_offsets(int n, float[] x, int _x_offset, int incx);

  @Override
  public native void srot(int n, float[] sx, int incx, float[] sy, int incy, float c, float s);

  @Override
  public void srot(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy, float c, float s) {
  srot_offsets(n, sx, _sx_offset, incx, sy, _sy_offset, incy, c, s);
  }

  public native void srot_offsets(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy, float c, float s);

  @Override
  public native void srotg(org.netlib.util.floatW sa, org.netlib.util.floatW sb, org.netlib.util.floatW c, org.netlib.util.floatW s);

  @Override
  public native void srotm(int n, float[] sx, int incx, float[] sy, int incy, float[] sparam);

  @Override
  public void srotm(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy, float[] sparam, int _sparam_offset) {
  srotm_offsets(n, sx, _sx_offset, incx, sy, _sy_offset, incy, sparam, _sparam_offset);
  }

  public native void srotm_offsets(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy, float[] sparam, int _sparam_offset);

  @Override
  public native void srotmg(org.netlib.util.floatW sd1, org.netlib.util.floatW sd2, org.netlib.util.floatW sx1, float sy1, float[] sparam);

  @Override
  public void srotmg(org.netlib.util.floatW sd1, org.netlib.util.floatW sd2, org.netlib.util.floatW sx1, float sy1, float[] sparam, int _sparam_offset) {
  srotmg_offsets(sd1, sd2, sx1, sy1, sparam, _sparam_offset);
  }

  public native void srotmg_offsets(org.netlib.util.floatW sd1, org.netlib.util.floatW sd2, org.netlib.util.floatW sx1, float sy1, float[] sparam, int _sparam_offset);

  @Override
  public native void ssbmv(java.lang.String uplo, int n, int k, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy);

  @Override
  public void ssbmv(java.lang.String uplo, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy) {
  ssbmv_offsets(uplo, n, k, alpha, a, _a_offset, lda, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void ssbmv_offsets(java.lang.String uplo, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  @Override
  public native void sscal(int n, float sa, float[] sx, int incx);

  @Override
  public void sscal(int n, float sa, float[] sx, int _sx_offset, int incx) {
  sscal_offsets(n, sa, sx, _sx_offset, incx);
  }

  public native void sscal_offsets(int n, float sa, float[] sx, int _sx_offset, int incx);

  @Override
  public native void sspmv(java.lang.String uplo, int n, float alpha, float[] ap, float[] x, int incx, float beta, float[] y, int incy);

  @Override
  public void sspmv(java.lang.String uplo, int n, float alpha, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy) {
  sspmv_offsets(uplo, n, alpha, ap, _ap_offset, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void sspmv_offsets(java.lang.String uplo, int n, float alpha, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  @Override
  public native void sspr(java.lang.String uplo, int n, float alpha, float[] x, int incx, float[] ap);

  @Override
  public void sspr(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] ap, int _ap_offset) {
  sspr_offsets(uplo, n, alpha, x, _x_offset, incx, ap, _ap_offset);
  }

  public native void sspr_offsets(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] ap, int _ap_offset);

  @Override
  public native void sspr2(java.lang.String uplo, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] ap);

  @Override
  public void sspr2(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] ap, int _ap_offset) {
  sspr2_offsets(uplo, n, alpha, x, _x_offset, incx, y, _y_offset, incy, ap, _ap_offset);
  }

  public native void sspr2_offsets(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] ap, int _ap_offset);

  @Override
  public native void sswap(int n, float[] sx, int incx, float[] sy, int incy);

  @Override
  public void sswap(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy) {
  sswap_offsets(n, sx, _sx_offset, incx, sy, _sy_offset, incy);
  }

  public native void sswap_offsets(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy);

  @Override
  public native void ssymm(java.lang.String side, java.lang.String uplo, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc);

  @Override
  public void ssymm(java.lang.String side, java.lang.String uplo, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc) {
  ssymm_offsets(side, uplo, m, n, alpha, a, _a_offset, lda, b, _b_offset, ldb, beta, c, _c_offset, Ldc);
  }

  public native void ssymm_offsets(java.lang.String side, java.lang.String uplo, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc);

  @Override
  public native void ssymv(java.lang.String uplo, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy);

  @Override
  public void ssymv(java.lang.String uplo, int n, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy) {
  ssymv_offsets(uplo, n, alpha, a, _a_offset, lda, x, _x_offset, incx, beta, y, _y_offset, incy);
  }

  public native void ssymv_offsets(java.lang.String uplo, int n, float alpha, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx, float beta, float[] y, int _y_offset, int incy);

  @Override
  public native void ssyr(java.lang.String uplo, int n, float alpha, float[] x, int incx, float[] a, int lda);

  @Override
  public void ssyr(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] a, int _a_offset, int lda) {
  ssyr_offsets(uplo, n, alpha, x, _x_offset, incx, a, _a_offset, lda);
  }

  public native void ssyr_offsets(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] a, int _a_offset, int lda);

  @Override
  public native void ssyr2(java.lang.String uplo, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a, int lda);

  @Override
  public void ssyr2(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] a, int _a_offset, int lda) {
  ssyr2_offsets(uplo, n, alpha, x, _x_offset, incx, y, _y_offset, incy, a, _a_offset, lda);
  }

  public native void ssyr2_offsets(java.lang.String uplo, int n, float alpha, float[] x, int _x_offset, int incx, float[] y, int _y_offset, int incy, float[] a, int _a_offset, int lda);

  @Override
  public native void ssyr2k(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int Ldc);

  @Override
  public void ssyr2k(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc) {
  ssyr2k_offsets(uplo, trans, n, k, alpha, a, _a_offset, lda, b, _b_offset, ldb, beta, c, _c_offset, Ldc);
  }

  public native void ssyr2k_offsets(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb, float beta, float[] c, int _c_offset, int Ldc);

  @Override
  public native void ssyrk(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int lda, float beta, float[] c, int Ldc);

  @Override
  public void ssyrk(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int _a_offset, int lda, float beta, float[] c, int _c_offset, int Ldc) {
  ssyrk_offsets(uplo, trans, n, k, alpha, a, _a_offset, lda, beta, c, _c_offset, Ldc);
  }

  public native void ssyrk_offsets(java.lang.String uplo, java.lang.String trans, int n, int k, float alpha, float[] a, int _a_offset, int lda, float beta, float[] c, int _c_offset, int Ldc);

  @Override
  public native void stbmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int lda, float[] x, int incx);

  @Override
  public void stbmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx) {
  stbmv_offsets(uplo, trans, diag, n, k, a, _a_offset, lda, x, _x_offset, incx);
  }

  public native void stbmv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx);

  @Override
  public native void stbsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int lda, float[] x, int incx);

  @Override
  public void stbsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx) {
  stbsv_offsets(uplo, trans, diag, n, k, a, _a_offset, lda, x, _x_offset, incx);
  }

  public native void stbsv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, int k, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx);

  @Override
  public native void stpmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, float[] x, int incx);

  @Override
  public void stpmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx) {
  stpmv_offsets(uplo, trans, diag, n, ap, _ap_offset, x, _x_offset, incx);
  }

  public native void stpmv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx);

  @Override
  public native void stpsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, float[] x, int incx);

  @Override
  public void stpsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx) {
  stpsv_offsets(uplo, trans, diag, n, ap, _ap_offset, x, _x_offset, incx);
  }

  public native void stpsv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] ap, int _ap_offset, float[] x, int _x_offset, int incx);

  @Override
  public native void strmm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb);

  @Override
  public void strmm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb) {
  strmm_offsets(side, uplo, transa, diag, m, n, alpha, a, _a_offset, lda, b, _b_offset, ldb);
  }

  public native void strmm_offsets(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb);

  @Override
  public native void strmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int lda, float[] x, int incx);

  @Override
  public void strmv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx) {
  strmv_offsets(uplo, trans, diag, n, a, _a_offset, lda, x, _x_offset, incx);
  }

  public native void strmv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx);

  @Override
  public native void strsm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb);

  @Override
  public void strsm(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb) {
  strsm_offsets(side, uplo, transa, diag, m, n, alpha, a, _a_offset, lda, b, _b_offset, ldb);
  }

  public native void strsm_offsets(java.lang.String side, java.lang.String uplo, java.lang.String transa, java.lang.String diag, int m, int n, float alpha, float[] a, int _a_offset, int lda, float[] b, int _b_offset, int ldb);

  @Override
  public native void strsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int lda, float[] x, int incx);

  @Override
  public void strsv(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx) {
  strsv_offsets(uplo, trans, diag, n, a, _a_offset, lda, x, _x_offset, incx);
  }

  public native void strsv_offsets(java.lang.String uplo, java.lang.String trans, java.lang.String diag, int n, float[] a, int _a_offset, int lda, float[] x, int _x_offset, int incx);
}