/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.MapService;
import com.hazelcast.map.tx.TransactionalMapProxySupport;
import com.hazelcast.map.tx.TxnValueWrapper;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TransactionalMapProxy
extends TransactionalMapProxySupport
implements TransactionalMap {
    private final Map<Object, TxnValueWrapper> txMap = new HashMap<Object, TxnValueWrapper>();

    public TransactionalMapProxy(String name, MapService mapService, NodeEngine nodeEngine, TransactionSupport transaction) {
        super(name, mapService, nodeEngine, transaction);
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkTransactionState();
        return this.txMap.containsKey(key) || this.containsKeyInternal(((MapService)this.getService()).toData(key, this.partitionStrategy));
    }

    @Override
    public int size() {
        this.checkTransactionState();
        int currentSize = this.sizeInternal();
        for (TxnValueWrapper wrapper : this.txMap.values()) {
            if (wrapper.type == TxnValueWrapper.Type.NEW) {
                ++currentSize;
                continue;
            }
            if (wrapper.type != TxnValueWrapper.Type.REMOVED) continue;
            --currentSize;
        }
        return currentSize;
    }

    @Override
    public boolean isEmpty() {
        this.checkTransactionState();
        return this.size() == 0;
    }

    @Override
    public Object get(Object key) {
        this.checkTransactionState();
        TxnValueWrapper currentValue = this.txMap.get(key);
        if (currentValue != null) {
            return this.checkIfRemoved(currentValue);
        }
        return ((MapService)this.getService()).toObject(this.getInternal(((MapService)this.getService()).toData(key, this.partitionStrategy)));
    }

    public Object getForUpdate(Object key) {
        this.checkTransactionState();
        TxnValueWrapper currentValue = this.txMap.get(key);
        if (currentValue != null) {
            return this.checkIfRemoved(currentValue);
        }
        Data dataKey = ((MapService)this.getService()).toData(key, this.partitionStrategy);
        return ((MapService)this.getService()).toObject(this.getForUpdateInternal(dataKey));
    }

    private Object checkIfRemoved(TxnValueWrapper wrapper) {
        this.checkTransactionState();
        return wrapper == null || wrapper.type == TxnValueWrapper.Type.REMOVED ? null : wrapper.value;
    }

    @Override
    public Object put(Object key, Object value) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        Object valueBeforeTxn = service.toObject(this.putInternal(service.toData(key, this.partitionStrategy), service.toData(value)));
        TxnValueWrapper currentValue = this.txMap.get(key);
        if (value != null) {
            TxnValueWrapper wrapper = valueBeforeTxn == null ? new TxnValueWrapper(value, TxnValueWrapper.Type.NEW) : new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED);
            this.txMap.put(key, wrapper);
        }
        return currentValue == null ? valueBeforeTxn : this.checkIfRemoved(currentValue);
    }

    public Object put(Object key, Object value, long ttl, TimeUnit timeUnit) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        Object valueBeforeTxn = service.toObject(this.putInternal(service.toData(key, this.partitionStrategy), service.toData(value), ttl, timeUnit));
        TxnValueWrapper currentValue = this.txMap.get(key);
        if (value != null) {
            TxnValueWrapper wrapper = valueBeforeTxn == null ? new TxnValueWrapper(value, TxnValueWrapper.Type.NEW) : new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED);
            this.txMap.put(key, wrapper);
        }
        return currentValue == null ? valueBeforeTxn : this.checkIfRemoved(currentValue);
    }

    @Override
    public void set(Object key, Object value) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        Data dataBeforeTxn = this.putInternal(service.toData(key, this.partitionStrategy), service.toData(value));
        if (value != null) {
            TxnValueWrapper wrapper = dataBeforeTxn == null ? new TxnValueWrapper(value, TxnValueWrapper.Type.NEW) : new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED);
            this.txMap.put(key, wrapper);
        }
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        this.checkTransactionState();
        TxnValueWrapper wrapper = this.txMap.get(key);
        boolean haveTxnPast = wrapper != null;
        MapService service = (MapService)this.getService();
        if (haveTxnPast) {
            if (wrapper.type != TxnValueWrapper.Type.REMOVED) {
                return wrapper.value;
            }
            this.putInternal(service.toData(key, this.partitionStrategy), service.toData(value));
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.NEW));
            return null;
        }
        Data oldValue = this.putIfAbsentInternal(service.toData(key, this.partitionStrategy), service.toData(value));
        if (oldValue == null) {
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.NEW));
        }
        return service.toObject(oldValue);
    }

    @Override
    public Object replace(Object key, Object value) {
        this.checkTransactionState();
        TxnValueWrapper wrapper = this.txMap.get(key);
        boolean haveTxnPast = wrapper != null;
        MapService service = (MapService)this.getService();
        if (haveTxnPast) {
            if (wrapper.type == TxnValueWrapper.Type.REMOVED) {
                return null;
            }
            this.putInternal(service.toData(key, this.partitionStrategy), service.toData(value));
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED));
            return wrapper.value;
        }
        Data oldValue = this.replaceInternal(service.toData(key, this.partitionStrategy), service.toData(value));
        if (oldValue != null) {
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED));
        }
        return service.toObject(oldValue);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        this.checkTransactionState();
        TxnValueWrapper wrapper = this.txMap.get(key);
        boolean haveTxnPast = wrapper != null;
        MapService service = (MapService)this.getService();
        if (haveTxnPast) {
            if (!wrapper.value.equals(oldValue)) {
                return false;
            }
            this.putInternal(service.toData(key, this.partitionStrategy), service.toData(newValue));
            this.txMap.put(key, new TxnValueWrapper(wrapper.value, TxnValueWrapper.Type.UPDATED));
            return true;
        }
        boolean success = this.replaceIfSameInternal(service.toData(key), service.toData(oldValue), service.toData(newValue));
        if (success) {
            this.txMap.put(key, new TxnValueWrapper(newValue, TxnValueWrapper.Type.UPDATED));
        }
        return success;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.checkTransactionState();
        TxnValueWrapper wrapper = this.txMap.get(key);
        MapService service = (MapService)this.getService();
        if (wrapper != null && !service.compare(this.name, wrapper.value, value)) {
            return false;
        }
        boolean removed = this.removeIfSameInternal(service.toData(key, this.partitionStrategy), value);
        if (removed) {
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.REMOVED));
        }
        return removed;
    }

    @Override
    public Object remove(Object key) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        Object valueBeforeTxn = service.toObject(this.removeInternal(service.toData(key, this.partitionStrategy)));
        TxnValueWrapper wrapper = null;
        if (valueBeforeTxn != null || this.txMap.containsKey(key)) {
            wrapper = this.txMap.put(key, new TxnValueWrapper(valueBeforeTxn, TxnValueWrapper.Type.REMOVED));
        }
        return wrapper == null ? valueBeforeTxn : this.checkIfRemoved(wrapper);
    }

    @Override
    public void delete(Object key) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        Data data = this.removeInternal(service.toData(key, this.partitionStrategy));
        if (data != null || this.txMap.containsKey(key)) {
            this.txMap.put(key, new TxnValueWrapper(service.toObject(data), TxnValueWrapper.Type.REMOVED));
        }
    }

    public Set<Object> keySet() {
        this.checkTransactionState();
        Set<Data> keySet = this.keySetInternal();
        HashSet<Object> keys = new HashSet<Object>(keySet.size());
        MapService service = (MapService)this.getService();
        for (Data data : keySet) {
            keys.add(service.toObject(data));
        }
        for (Map.Entry entry : this.txMap.entrySet()) {
            if (TxnValueWrapper.Type.NEW.equals((Object)((TxnValueWrapper)entry.getValue()).type)) {
                keys.add(entry.getKey());
                continue;
            }
            if (!TxnValueWrapper.Type.REMOVED.equals((Object)((TxnValueWrapper)entry.getValue()).type)) continue;
            keys.remove(entry.getKey());
        }
        return keys;
    }

    public Set keySet(Predicate predicate) {
        this.checkTransactionState();
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        if (predicate instanceof PagingPredicate) {
            throw new NullPointerException("Paging is not supported for Transactional queries!");
        }
        MapService service = (MapService)this.getService();
        QueryResultSet queryResultSet = (QueryResultSet)this.queryInternal(predicate, IterationType.KEY, false);
        HashSet<Object> keySet = new HashSet<Object>(queryResultSet);
        for (Map.Entry<Object, TxnValueWrapper> entry : this.txMap.entrySet()) {
            if (!TxnValueWrapper.Type.REMOVED.equals((Object)entry.getValue().type)) {
                Object value;
                Object object = value = entry.getValue().value instanceof Data ? service.toObject(entry.getValue().value) : entry.getValue().value;
                SerializationService ss = this.getNodeEngine().getSerializationService();
                QueryEntry queryEntry = new QueryEntry(ss, service.toData(entry.getKey()), entry.getKey(), value);
                if (!predicate.apply(queryEntry)) continue;
                keySet.add(entry.getKey());
                continue;
            }
            keySet.remove(entry.getKey());
        }
        return keySet;
    }

    public Collection<Object> values() {
        this.checkTransactionState();
        Collection<Data> dataSet = this.valuesInternal();
        ArrayList<Object> values = new ArrayList<Object>(dataSet.size());
        for (Data data : dataSet) {
            values.add(((MapService)this.getService()).toObject(data));
        }
        for (TxnValueWrapper wrapper : this.txMap.values()) {
            if (TxnValueWrapper.Type.NEW.equals((Object)wrapper.type)) {
                values.add(wrapper.value);
                continue;
            }
            if (!TxnValueWrapper.Type.REMOVED.equals((Object)wrapper.type)) continue;
            values.remove(wrapper.value);
        }
        return values;
    }

    public Collection values(Predicate predicate) {
        this.checkTransactionState();
        if (predicate == null) {
            throw new NullPointerException("Predicate can not be null!");
        }
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("Paging is not supported for Transactional queries");
        }
        MapService service = (MapService)this.getService();
        QueryResultSet queryResultSet = (QueryResultSet)this.queryInternal(predicate, IterationType.ENTRY, false);
        HashSet<Object> valueSet = new HashSet<Object>();
        HashSet<Object> keyWontBeIncluded = new HashSet<Object>();
        for (Map.Entry<Object, TxnValueWrapper> entry : this.txMap.entrySet()) {
            Object entryValue;
            Object objectValue;
            boolean isRemoved = TxnValueWrapper.Type.REMOVED.equals((Object)entry.getValue().type);
            boolean isUpdated = TxnValueWrapper.Type.UPDATED.equals((Object)entry.getValue().type);
            if (isRemoved) {
                keyWontBeIncluded.add(entry.getKey());
                continue;
            }
            if (isUpdated) {
                keyWontBeIncluded.add(entry.getKey());
            }
            Object object = objectValue = (entryValue = entry.getValue().value) instanceof Data ? service.toObject(entryValue) : entryValue;
            SerializationService ss = this.getNodeEngine().getSerializationService();
            QueryEntry queryEntry = new QueryEntry(ss, service.toData(entry.getKey()), entry.getKey(), objectValue);
            if (!predicate.apply(queryEntry)) continue;
            valueSet.add(entryValue);
        }
        Iterator<Map.Entry> iterator = queryResultSet.rawIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (keyWontBeIncluded.contains(entry.getKey())) continue;
            valueSet.add(entry.getValue());
        }
        return valueSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionalMap");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

