/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.queue.QueueContainer;
import com.hazelcast.queue.QueueOperation;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public class TxnPrepareBackupOperation
extends QueueOperation
implements BackupOperation {
    long itemId;
    boolean pollOperation;
    String transactionId;

    public TxnPrepareBackupOperation() {
    }

    public TxnPrepareBackupOperation(String name, long itemId, boolean pollOperation, String transactionId) {
        super(name);
        this.itemId = itemId;
        this.pollOperation = pollOperation;
        this.transactionId = transactionId;
    }

    @Override
    public void run() throws Exception {
        QueueContainer container = this.getOrCreateContainer();
        if (this.pollOperation) {
            container.txnPollBackupReserve(this.itemId, this.transactionId);
        } else {
            container.txnOfferBackupReserve(this.itemId, this.transactionId);
        }
        this.response = true;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.pollOperation);
        out.writeUTF(this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.pollOperation = in.readBoolean();
        this.transactionId = in.readUTF();
    }

    @Override
    public int getId() {
        return 27;
    }
}

