/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.impl.DistributedObjectEventPacket;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.executor.StripedRunnable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ProxyServiceImpl
implements ProxyService,
PostJoinAwareService,
EventPublishingService<DistributedObjectEventPacket, Object> {
    static final String SERVICE_NAME = "hz:core:proxyService";
    private final NodeEngineImpl nodeEngine;
    private final ConcurrentMap<String, ProxyRegistry> registries = new ConcurrentHashMap<String, ProxyRegistry>();
    private final ConcurrentMap<String, DistributedObjectListener> listeners = new ConcurrentHashMap<String, DistributedObjectListener>();
    private final ILogger logger;
    private final ConstructorFunction<String, ProxyRegistry> registryConstructor = new ConstructorFunction<String, ProxyRegistry>(){

        @Override
        public ProxyRegistry createNew(String serviceName) {
            return new ProxyRegistry(serviceName);
        }
    };

    ProxyServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(ProxyService.class.getName());
    }

    void init() {
        this.nodeEngine.getEventService().registerListener(SERVICE_NAME, SERVICE_NAME, new Object());
    }

    @Override
    public int getProxyCount() {
        int count = 0;
        for (ProxyRegistry registry : this.registries.values()) {
            count += registry.getProxyCount();
        }
        return count;
    }

    @Override
    public void initializeDistributedObject(String serviceName, String name) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (name == null) {
            throw new NullPointerException("Object name is required!");
        }
        ProxyRegistry registry = ConcurrencyUtil.getOrPutIfAbsent(this.registries, serviceName, this.registryConstructor);
        registry.getOrCreateProxy(name, true, true);
    }

    @Override
    public DistributedObject getDistributedObject(String serviceName, String name) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (name == null) {
            throw new NullPointerException("Object name is required!");
        }
        ProxyRegistry registry = ConcurrencyUtil.getOrPutIfAbsent(this.registries, serviceName, this.registryConstructor);
        return registry.getOrCreateProxy(name, true, true);
    }

    @Override
    public void destroyDistributedObject(String serviceName, String name) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (name == null) {
            throw new NullPointerException("Object name is required!");
        }
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        ArrayList<InternalCompletableFuture> calls = new ArrayList<InternalCompletableFuture>(members.size());
        for (MemberImpl memberImpl : members) {
            if (memberImpl.localMember()) continue;
            InternalCompletableFuture f = this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, (Operation)new DistributedObjectDestroyOperation(serviceName, name), memberImpl.getAddress()).setTryCount(10).invoke();
            calls.add(f);
        }
        this.destroyLocalDistributedObject(serviceName, name, true);
        for (Future future : calls) {
            try {
                future.get(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
    }

    private void destroyLocalDistributedObject(String serviceName, String name, boolean fireEvent) {
        RemoteService service;
        ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
        if (registry != null) {
            registry.destroyProxy(name, fireEvent);
        }
        if ((service = (RemoteService)this.nodeEngine.getService(serviceName)) != null) {
            service.destroyDistributedObject(name);
        }
        DistributedObjectDestroyedException cause = new DistributedObjectDestroyedException(serviceName, name);
        this.nodeEngine.waitNotifyService.cancelWaitingOps(serviceName, name, cause);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects(String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        LinkedList<DistributedObject> objects = new LinkedList<DistributedObject>();
        ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
        if (registry != null) {
            Collection futures = registry.proxies.values();
            for (DistributedObjectFuture future : futures) {
                objects.add(future.get());
            }
        }
        return objects;
    }

    @Override
    public Collection<DistributedObject> getAllDistributedObjects() {
        LinkedList<DistributedObject> objects = new LinkedList<DistributedObject>();
        for (ProxyRegistry registry : this.registries.values()) {
            Collection futures = registry.proxies.values();
            for (DistributedObjectFuture future : futures) {
                objects.add(future.get());
            }
        }
        return objects;
    }

    @Override
    public String addProxyListener(DistributedObjectListener distributedObjectListener) {
        String id = UuidUtil.buildRandomUuidString();
        this.listeners.put(id, distributedObjectListener);
        return id;
    }

    @Override
    public boolean removeProxyListener(String registrationId) {
        return this.listeners.remove(registrationId) != null;
    }

    @Override
    public void dispatchEvent(DistributedObjectEventPacket eventPacket, Object ignore) {
        String serviceName = eventPacket.getServiceName();
        if (eventPacket.getEventType() == DistributedObjectEvent.EventType.CREATED) {
            try {
                ProxyRegistry registry = ConcurrencyUtil.getOrPutIfAbsent(this.registries, serviceName, this.registryConstructor);
                if (!registry.contains(eventPacket.getName())) {
                    registry.createProxy(eventPacket.getName(), false, true);
                }
            }
            catch (HazelcastInstanceNotActiveException ignored) {}
        } else {
            ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
            if (registry != null) {
                registry.destroyProxy(eventPacket.getName(), false);
            }
        }
    }

    @Override
    public Operation getPostJoinOperation() {
        LinkedList<ProxyInfo> proxies = new LinkedList<ProxyInfo>();
        for (ProxyRegistry registry : this.registries.values()) {
            for (Map.Entry entry : registry.proxies.entrySet()) {
                DistributedObject distributedObject;
                DistributedObjectFuture future = (DistributedObjectFuture)entry.getValue();
                if (!future.isSet() || !((distributedObject = future.get()) instanceof InitializingObject)) continue;
                proxies.add(new ProxyInfo(registry.serviceName, (String)entry.getKey()));
            }
        }
        return proxies.isEmpty() ? null : new PostJoinProxyOperation(proxies);
    }

    void shutdown() {
        for (ProxyRegistry registry : this.registries.values()) {
            registry.destroy();
        }
        this.registries.clear();
        this.listeners.clear();
    }

    private static class ProxyInfo {
        final String serviceName;
        final String objectName;

        private ProxyInfo(String serviceName, String objectName) {
            this.serviceName = serviceName;
            this.objectName = objectName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProxyInfo{");
            sb.append("serviceName='").append(this.serviceName).append('\'');
            sb.append(", objectName='").append(this.objectName).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static class PostJoinProxyOperation
    extends AbstractOperation {
        private Collection<ProxyInfo> proxies;

        public PostJoinProxyOperation() {
        }

        public PostJoinProxyOperation(Collection<ProxyInfo> proxies) {
            this.proxies = proxies;
        }

        @Override
        public void run() throws Exception {
            if (this.proxies != null && this.proxies.size() > 0) {
                NodeEngine nodeEngine = this.getNodeEngine();
                ProxyServiceImpl proxyService = (ProxyServiceImpl)this.getService();
                for (ProxyInfo proxy : this.proxies) {
                    DistributedObject object;
                    ProxyRegistry registry = (ProxyRegistry)ConcurrencyUtil.getOrPutIfAbsent(proxyService.registries, proxy.serviceName, proxyService.registryConstructor);
                    DistributedObjectFuture future = registry.createProxy(proxy.objectName, false, false);
                    if (future == null || !((object = future.get()) instanceof InitializingObject)) continue;
                    nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((InitializingObject)((Object)object)).initialize();
                            }
                            catch (Exception e) {
                                PostJoinProxyOperation.this.getLogger().warning("Error while initializing proxy: " + object, e);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public String getServiceName() {
            return ProxyServiceImpl.SERVICE_NAME;
        }

        @Override
        public boolean returnsResponse() {
            return false;
        }

        @Override
        protected void writeInternal(ObjectDataOutput out) throws IOException {
            super.writeInternal(out);
            int len = this.proxies != null ? this.proxies.size() : 0;
            out.writeInt(len);
            if (len > 0) {
                for (ProxyInfo proxy : this.proxies) {
                    out.writeUTF(proxy.serviceName);
                    out.writeObject(proxy.objectName);
                }
            }
        }

        @Override
        protected void readInternal(ObjectDataInput in) throws IOException {
            super.readInternal(in);
            int len = in.readInt();
            if (len > 0) {
                this.proxies = new ArrayList<ProxyInfo>(len);
                for (int i = 0; i < len; ++i) {
                    ProxyInfo proxy = new ProxyInfo(in.readUTF(), (String)in.readObject());
                    this.proxies.add(proxy);
                }
            }
        }
    }

    public static class DistributedObjectDestroyOperation
    extends AbstractOperation {
        private String serviceName;
        private String name;

        public DistributedObjectDestroyOperation() {
        }

        public DistributedObjectDestroyOperation(String serviceName, String name) {
            this.serviceName = serviceName;
            this.name = name;
        }

        @Override
        public void run() throws Exception {
            ProxyServiceImpl proxyService = (ProxyServiceImpl)this.getService();
            proxyService.destroyLocalDistributedObject(this.serviceName, this.name, false);
        }

        @Override
        public boolean returnsResponse() {
            return true;
        }

        @Override
        public Object getResponse() {
            return Boolean.TRUE;
        }

        @Override
        protected void writeInternal(ObjectDataOutput out) throws IOException {
            super.writeInternal(out);
            out.writeUTF(this.serviceName);
            out.writeObject(this.name);
        }

        @Override
        protected void readInternal(ObjectDataInput in) throws IOException {
            super.readInternal(in);
            this.serviceName = in.readUTF();
            this.name = (String)in.readObject();
        }
    }

    private class ProxyEventProcessor
    implements StripedRunnable {
        final DistributedObjectEvent.EventType type;
        final String serviceName;
        final DistributedObject object;

        private ProxyEventProcessor(DistributedObjectEvent.EventType eventType, String serviceName, DistributedObject object) {
            this.type = eventType;
            this.serviceName = serviceName;
            this.object = object;
        }

        @Override
        public void run() {
            DistributedObjectEvent event = new DistributedObjectEvent(this.type, this.serviceName, this.object);
            for (DistributedObjectListener listener : ProxyServiceImpl.this.listeners.values()) {
                if (DistributedObjectEvent.EventType.CREATED.equals((Object)this.type)) {
                    listener.distributedObjectCreated(event);
                    continue;
                }
                if (!DistributedObjectEvent.EventType.DESTROYED.equals((Object)this.type)) continue;
                listener.distributedObjectDestroyed(event);
            }
        }

        @Override
        public int getKey() {
            return this.object.getName().hashCode();
        }
    }

    private class DistributedObjectFuture {
        volatile DistributedObject proxy;

        private DistributedObjectFuture() {
        }

        boolean isSet() {
            return this.proxy != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DistributedObject get() {
            if (this.proxy == null) {
                boolean interrupted = false;
                DistributedObjectFuture distributedObjectFuture = this;
                synchronized (distributedObjectFuture) {
                    while (this.proxy == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(DistributedObject o) {
            if (o == null) {
                throw new IllegalArgumentException();
            }
            DistributedObjectFuture distributedObjectFuture = this;
            synchronized (distributedObjectFuture) {
                this.proxy = o;
                this.notifyAll();
            }
        }
    }

    private class ProxyRegistry {
        final String serviceName;
        final RemoteService service;
        final ConcurrentMap<String, DistributedObjectFuture> proxies = new ConcurrentHashMap<String, DistributedObjectFuture>();

        private ProxyRegistry(String serviceName) {
            this.serviceName = serviceName;
            this.service = (RemoteService)ProxyServiceImpl.this.nodeEngine.getService(serviceName);
            if (this.service == null) {
                if (ProxyServiceImpl.this.nodeEngine.isActive()) {
                    throw new IllegalArgumentException("Unknown service: " + serviceName);
                }
                throw new HazelcastInstanceNotActiveException();
            }
        }

        DistributedObject getOrCreateProxy(String name, boolean publishEvent, boolean initialize) {
            DistributedObjectFuture proxyFuture = (DistributedObjectFuture)this.proxies.get(name);
            if (proxyFuture == null) {
                if (!ProxyServiceImpl.this.nodeEngine.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                proxyFuture = this.createProxy(name, publishEvent, initialize);
                if (proxyFuture == null) {
                    return this.getOrCreateProxy(name, publishEvent, initialize);
                }
            }
            return proxyFuture.get();
        }

        DistributedObjectFuture createProxy(String name, boolean publishEvent, boolean initialize) {
            if (!this.proxies.containsKey(name)) {
                if (!ProxyServiceImpl.this.nodeEngine.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                DistributedObjectFuture proxyFuture = new DistributedObjectFuture();
                if (this.proxies.putIfAbsent(name, proxyFuture) == null) {
                    DistributedObject proxy = this.service.createDistributedObject(name);
                    if (initialize && proxy instanceof InitializingObject) {
                        try {
                            ((InitializingObject)((Object)proxy)).initialize();
                        }
                        catch (Exception e) {
                            ProxyServiceImpl.this.logger.warning("Error while initializing proxy: " + proxy, e);
                        }
                    }
                    ((ProxyServiceImpl)ProxyServiceImpl.this).nodeEngine.eventService.executeEventCallback(new ProxyEventProcessor(DistributedObjectEvent.EventType.CREATED, this.serviceName, proxy));
                    if (publishEvent) {
                        this.publish(new DistributedObjectEventPacket(DistributedObjectEvent.EventType.CREATED, this.serviceName, name));
                    }
                    proxyFuture.set(proxy);
                    return proxyFuture;
                }
            }
            return null;
        }

        void destroyProxy(String name, boolean publishEvent) {
            DistributedObjectFuture proxyFuture = (DistributedObjectFuture)this.proxies.remove(name);
            if (proxyFuture != null) {
                DistributedObject proxy = proxyFuture.get();
                ((ProxyServiceImpl)ProxyServiceImpl.this).nodeEngine.eventService.executeEventCallback(new ProxyEventProcessor(DistributedObjectEvent.EventType.DESTROYED, this.serviceName, proxy));
                if (publishEvent) {
                    this.publish(new DistributedObjectEventPacket(DistributedObjectEvent.EventType.DESTROYED, this.serviceName, name));
                }
            }
        }

        private void publish(DistributedObjectEventPacket event) {
            EventService eventService = ProxyServiceImpl.this.nodeEngine.getEventService();
            Collection<EventRegistration> registrations = eventService.getRegistrations(ProxyServiceImpl.SERVICE_NAME, ProxyServiceImpl.SERVICE_NAME);
            eventService.publishEvent(ProxyServiceImpl.SERVICE_NAME, registrations, (Object)event, event.getName().hashCode());
        }

        private boolean contains(String name) {
            return this.proxies.containsKey(name);
        }

        void destroy() {
            for (DistributedObjectFuture future : this.proxies.values()) {
                DistributedObject distributedObject = future.get();
                if (!(distributedObject instanceof AbstractDistributedObject)) continue;
                ((AbstractDistributedObject)distributedObject).invalidate();
            }
            this.proxies.clear();
        }

        public int getProxyCount() {
            return this.proxies.size();
        }
    }
}

