/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.result.BigDecimalExtractor;
import com.sap.cloud.sdk.result.BigIntegerExtractor;
import com.sap.cloud.sdk.result.BooleanExtractor;
import com.sap.cloud.sdk.result.ByteExtractor;
import com.sap.cloud.sdk.result.CharacterExtractor;
import com.sap.cloud.sdk.result.CollectedResultCollection;
import com.sap.cloud.sdk.result.CollectionExtractor;
import com.sap.cloud.sdk.result.DoubleExtractor;
import com.sap.cloud.sdk.result.FloatExtractor;
import com.sap.cloud.sdk.result.GenericCollectionExtractor;
import com.sap.cloud.sdk.result.GenericObjectExtractor;
import com.sap.cloud.sdk.result.IntegerExtractor;
import com.sap.cloud.sdk.result.LongExtractor;
import com.sap.cloud.sdk.result.ObjectExtractor;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultObject;
import com.sap.cloud.sdk.result.ResultPrimitive;
import com.sap.cloud.sdk.result.ShortExtractor;
import com.sap.cloud.sdk.result.StringExtractor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultCollectedResultCollection
implements CollectedResultCollection {
    private final String collectedElementName;
    private final Iterable<ResultElement> resultElements;

    @Override
    public <T> List<T> asList(Class<T> objectType) throws UnsupportedOperationException {
        return this.collectListFromObject(new GenericObjectExtractor<T>(objectType));
    }

    private <T> List<T> collectListFromObject(ObjectExtractor<T> extractor) throws UnsupportedOperationException {
        return this.collectListFromCollection(new GenericCollectionExtractor<T>(extractor));
    }

    private <T> List<T> collectListFromCollection(CollectionExtractor<List<T>, T> extractor) throws UnsupportedOperationException {
        return this.getCollection(extractor, Lists.newArrayList());
    }

    private <CollectionT extends Collection<T>, T> CollectionT getCollection(CollectionExtractor<CollectionT, T> extractor, CollectionT collection) throws UnsupportedOperationException {
        try {
            for (ResultElement element : this.resultElements) {
                if (!element.isResultObject()) continue;
                ResultElement nestedElement = element.getAsObject().get(this.collectedElementName);
                collection.addAll(extractor.extract(nestedElement));
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to collect nested elements with name " + this.collectedElementName + ".", e);
        }
        return collection;
    }

    @Override
    public <T> Set<T> asSet(Class<T> objectType) throws UnsupportedOperationException {
        return this.collectSetFromObject(new GenericObjectExtractor<T>(objectType));
    }

    private <T> Set<T> collectSetFromObject(ObjectExtractor<T> extractor) throws UnsupportedOperationException {
        return this.collectSetFromCollection(resultElement -> Collections.singleton(extractor.extract(resultElement)));
    }

    private <T> Set<T> collectSetFromCollection(CollectionExtractor<Set<T>, T> extractor) throws UnsupportedOperationException {
        return this.getCollection(extractor, Sets.newHashSet());
    }

    @Override
    public List<Boolean> asBooleanList() throws UnsupportedOperationException {
        return this.collectListFromObject(new BooleanExtractor());
    }

    @Override
    public Set<Boolean> asBooleanSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new BooleanExtractor());
    }

    @Override
    public List<Byte> asByteList() throws UnsupportedOperationException {
        return this.collectListFromObject(new ByteExtractor());
    }

    @Override
    public Set<Byte> asByteSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new ByteExtractor());
    }

    @Override
    public List<Character> asCharacterList() throws UnsupportedOperationException {
        return this.collectListFromObject(new CharacterExtractor());
    }

    @Override
    public Set<Character> asCharacterSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new CharacterExtractor());
    }

    @Override
    public List<String> asStringList() throws UnsupportedOperationException {
        return this.collectListFromObject(new StringExtractor());
    }

    @Override
    public Set<String> asStringSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new StringExtractor());
    }

    @Override
    public List<Integer> asIntegerList() throws UnsupportedOperationException {
        return this.collectListFromObject(new IntegerExtractor());
    }

    @Override
    public Set<Integer> asIntegerSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new IntegerExtractor());
    }

    @Override
    public List<Short> asShortList() throws UnsupportedOperationException {
        return this.collectListFromObject(new ShortExtractor());
    }

    @Override
    public Set<Short> asShortSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new ShortExtractor());
    }

    @Override
    public List<Long> asLongList() throws UnsupportedOperationException {
        return this.collectListFromObject(new LongExtractor());
    }

    @Override
    public Set<Long> asLongSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new LongExtractor());
    }

    @Override
    public List<Float> asFloatList() throws UnsupportedOperationException {
        return this.collectListFromObject(new FloatExtractor());
    }

    @Override
    public Set<Float> asFloatSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new FloatExtractor());
    }

    @Override
    public List<Double> asDoubleList() throws UnsupportedOperationException {
        return this.collectListFromObject(new DoubleExtractor());
    }

    @Override
    public Set<Double> asDoubleSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new DoubleExtractor());
    }

    @Override
    public List<BigInteger> asBigIntegerList() throws UnsupportedOperationException {
        return this.collectListFromObject(new BigIntegerExtractor());
    }

    @Override
    public Set<BigInteger> asBigIntegerSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new BigIntegerExtractor());
    }

    @Override
    public List<BigDecimal> asBigDecimalList() throws UnsupportedOperationException {
        return this.collectListFromObject(new BigDecimalExtractor());
    }

    @Override
    public Set<BigDecimal> asBigDecimalSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new BigDecimalExtractor());
    }

    public boolean isResultPrimitive() {
        return false;
    }

    public boolean isResultCollection() {
        return true;
    }

    public boolean isResultObject() {
        return false;
    }

    public ResultPrimitive getAsPrimitive() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public ResultObject getAsObject() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as object.");
    }

    public boolean asBoolean() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public byte asByte() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public char asCharacter() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public String asString() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public int asInteger() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public short asShort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public long asLong() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public float asFloat() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public double asDouble() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public BigInteger asBigInteger() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public BigDecimal asBigDecimal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get a collection as primitive.");
    }

    public Iterator<ResultElement> iterator() {
        return this.resultElements.iterator();
    }

    public DefaultCollectedResultCollection(String collectedElementName, Iterable<ResultElement> resultElements) {
        this.collectedElementName = collectedElementName;
        this.resultElements = resultElements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultCollectedResultCollection)) {
            return false;
        }
        DefaultCollectedResultCollection other = (DefaultCollectedResultCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$collectedElementName = this.getCollectedElementName();
        String other$collectedElementName = other.getCollectedElementName();
        if (this$collectedElementName == null ? other$collectedElementName != null : !this$collectedElementName.equals(other$collectedElementName)) {
            return false;
        }
        Iterable<ResultElement> this$resultElements = this.getResultElements();
        Iterable<ResultElement> other$resultElements = other.getResultElements();
        return !(this$resultElements == null ? other$resultElements != null : !this$resultElements.equals(other$resultElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultCollectedResultCollection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $collectedElementName = this.getCollectedElementName();
        result = result * 59 + ($collectedElementName == null ? 43 : $collectedElementName.hashCode());
        Iterable<ResultElement> $resultElements = this.getResultElements();
        result = result * 59 + ($resultElements == null ? 43 : $resultElements.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultCollectedResultCollection(collectedElementName=" + this.getCollectedElementName() + ", resultElements=" + this.getResultElements() + ")";
    }

    public String getCollectedElementName() {
        return this.collectedElementName;
    }

    public Iterable<ResultElement> getResultElements() {
        return this.resultElements;
    }
}

