/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.sap.cloud.sdk.result.DefaultResultCollection;
import com.sap.cloud.sdk.result.GsonResultObject;
import com.sap.cloud.sdk.result.GsonResultPrimitive;
import com.sap.cloud.sdk.result.ResultCollection;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultElementFactory;
import com.sap.cloud.sdk.result.ResultObject;
import com.sap.cloud.sdk.result.ResultPrimitive;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class GsonResultElementFactory
implements ResultElementFactory<JsonElement> {
    protected final GsonBuilder gsonBuilder;

    protected ResultPrimitive newPrimitive(JsonElement resultElement) {
        return new GsonResultPrimitive(resultElement.getAsJsonPrimitive());
    }

    protected ResultObject newObject(JsonElement resultElement) {
        return new GsonResultObject(resultElement.getAsJsonObject(), this);
    }

    protected ResultCollection newCollection(JsonElement resultElement) {
        ArrayList<ResultElement> resultElements = new ArrayList<ResultElement>();
        for (JsonElement jsonElement : resultElement.getAsJsonArray()) {
            resultElements.add(this.create(jsonElement));
        }
        return new DefaultResultCollection(resultElements);
    }

    @Override
    @Nullable
    public ResultElement create(@Nullable JsonElement resultElement) throws IllegalArgumentException {
        if (resultElement == null) {
            return null;
        }
        if (resultElement.isJsonPrimitive()) {
            return this.newPrimitive(resultElement);
        }
        if (resultElement.isJsonObject()) {
            return this.newObject(resultElement);
        }
        if (resultElement.isJsonArray()) {
            return this.newCollection(resultElement);
        }
        throw new IllegalArgumentException("Failed to convert " + JsonElement.class.getSimpleName() + " " + resultElement + " to instance of " + ResultElement.class.getSimpleName() + ".");
    }

    public GsonResultElementFactory(GsonBuilder gsonBuilder) {
        this.gsonBuilder = gsonBuilder;
    }

    public GsonBuilder getGsonBuilder() {
        return this.gsonBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GsonResultElementFactory)) {
            return false;
        }
        GsonResultElementFactory other = (GsonResultElementFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GsonBuilder this$gsonBuilder = this.getGsonBuilder();
        GsonBuilder other$gsonBuilder = other.getGsonBuilder();
        return !(this$gsonBuilder == null ? other$gsonBuilder != null : !this$gsonBuilder.equals(other$gsonBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GsonResultElementFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GsonBuilder $gsonBuilder = this.getGsonBuilder();
        result = result * 59 + ($gsonBuilder == null ? 43 : $gsonBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "GsonResultElementFactory(gsonBuilder=" + this.getGsonBuilder() + ")";
    }
}

