/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.prov.jacksonutil;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sap.cloud.servicesdk.prov.jacksonutil.CustomPropertyNameingStrategy;
import com.sap.cloud.servicesdk.prov.jacksonutil.ExclusionAnnotationIntrospector;

public class JacksonMapper {
    public static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new CustomPropertyNameingStrategy());
        ExclusionAnnotationIntrospector annoinspector = new ExclusionAnnotationIntrospector();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)annoinspector);
        return mapper;
    }
}

