/*
 * Decompiled with CFR 0.152.
 */
package com.yungouos.pay.alipay;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yungouos.pay.common.PayException;
import com.yungouos.pay.config.AlipayApiConfig;
import com.yungouos.pay.entity.AliPayH5Biz;
import com.yungouos.pay.entity.AliPayJsPayBiz;
import com.yungouos.pay.entity.HbFqBiz;
import com.yungouos.pay.entity.RefundOrder;
import com.yungouos.pay.entity.RefundSearch;
import com.yungouos.pay.util.PaySignUtil;
import java.util.HashMap;

public class AliPay {
    public static String nativePay(String out_trade_no, String total_fee, String mch_id, String body, String type, String attach, String notify_url, String config_no, String auto, String auto_node, HbFqBiz hbFqBiz, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String resultUrl = null;
        try {
            JSONObject hbfqJson;
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            if (StrUtil.isBlank(type)) {
                type = "2";
            }
            params.put("type", type);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            if (hbFqBiz != null && (hbfqJson = (JSONObject)JSON.toJSON(hbFqBiz)) != null) {
                params.put("hb_fq", hbfqJson.toJSONString());
            }
            params.put("sign", sign);
            String result = HttpRequest.post(AlipayApiConfig.nativeApiUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            resultUrl = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return resultUrl;
    }

    public static String wapPay(String out_trade_no, String total_fee, String mch_id, String body, String attach, String notify_url, String config_no, String auto, String auto_node, HbFqBiz hbFqBiz, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String resultUrl = null;
        try {
            JSONObject hbfqJson;
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            if (hbFqBiz != null && (hbfqJson = (JSONObject)JSON.toJSON(hbFqBiz)) != null) {
                params.put("hb_fq", hbfqJson.toJSONString());
            }
            params.put("sign", sign);
            String result = HttpRequest.post(AlipayApiConfig.wapPayUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            resultUrl = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return resultUrl;
    }

    public static AliPayJsPayBiz jsPay(String out_trade_no, String total_fee, String mch_id, String buyer_id, String body, String attach, String notify_url, String config_no, String auto, String auto_node, HbFqBiz hbFqBiz, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AliPayJsPayBiz aliPayJsPayBiz = null;
        try {
            JSONObject hbfqJson;
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(buyer_id)) {
                throw new PayException("\u4e70\u5bb6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("buyer_id", buyer_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            if (hbFqBiz != null && (hbfqJson = (JSONObject)JSON.toJSON(hbFqBiz)) != null) {
                params.put("hb_fq", hbfqJson.toJSONString());
            }
            params.put("sign", sign);
            String result = HttpRequest.post(AlipayApiConfig.jsPayUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (data == null) {
                throw new PayException("API\u7ed3\u679c\u4e3a\u7a7a");
            }
            aliPayJsPayBiz = JSONObject.toJavaObject(data, AliPayJsPayBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return aliPayJsPayBiz;
    }

    public static AliPayH5Biz h5Pay(String out_trade_no, String total_fee, String mch_id, String body, String attach, String notify_url, String return_url, String config_no, String auto, String auto_node, HbFqBiz hbFqBiz, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AliPayH5Biz aliPayH5Biz = null;
        try {
            JSONObject hbfqJson;
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("return_url", return_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            if (hbFqBiz != null && (hbfqJson = (JSONObject)JSON.toJSON(hbFqBiz)) != null) {
                params.put("hb_fq", hbfqJson.toJSONString());
            }
            params.put("sign", sign);
            String result = HttpRequest.post(AlipayApiConfig.h5PayUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (data == null) {
                throw new PayException("API\u7ed3\u679c\u4e3a\u7a7a");
            }
            aliPayH5Biz = JSON.toJavaObject(data, AliPayH5Biz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return aliPayH5Biz;
    }

    public static String appPay(String out_trade_no, String total_fee, String mch_id, String body, String attach, String notify_url, String config_no, String auto, String auto_node, HbFqBiz hbFqBiz, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String appParams = null;
        try {
            JSONObject hbfqJson;
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            if (hbFqBiz != null && (hbfqJson = (JSONObject)JSON.toJSON(hbFqBiz)) != null) {
                params.put("hb_fq", hbfqJson.toJSONString());
            }
            params.put("sign", sign);
            String result = HttpRequest.post(AlipayApiConfig.appPayUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            appParams = jsonObject.getString("data");
            if (StrUtil.isBlank(appParams)) {
                throw new PayException("APP\u4e0b\u5355\u5931\u8d25");
            }
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return appParams;
    }

    public static RefundOrder orderRefund(String out_trade_no, String mch_id, String money, String refund_desc, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        RefundOrder refundOrder = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(money)) {
                throw new PayException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("mch_id", mch_id);
            params.put("money", money);
            String sign = PaySignUtil.createSign(params, key);
            params.put("refund_desc", refund_desc);
            params.put("sign", sign);
            String result = HttpRequest.post(AlipayApiConfig.refundOrderUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = jsonObject.getJSONObject("data");
            if (json == null) {
                throw new PayException("API\u7ed3\u679c\u6570\u636e\u8f6c\u6362\u9519\u8bef");
            }
            refundOrder = JSONObject.toJavaObject(json, RefundOrder.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return refundOrder;
    }

    public static RefundSearch getRefundResult(String refund_no, String mch_id, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        RefundSearch refundSearch = null;
        try {
            if (StrUtil.isBlank(refund_no)) {
                throw new PayException("\u9000\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("refund_no", refund_no);
            params.put("mch_id", mch_id);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.get(AlipayApiConfig.getRefundResultUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = jsonObject.getJSONObject("data");
            if (json == null) {
                throw new PayException("API\u7ed3\u679c\u6570\u636e\u8f6c\u6362\u9519\u8bef");
            }
            refundSearch = JSONObject.toJavaObject(json, RefundSearch.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return refundSearch;
    }
}

