/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dal.show;

import com.google.common.base.Optional;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dql.common.MemoryMergedResult;
import io.shardingsphere.core.merger.dql.common.MemoryQueryResultRow;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ShowTablesMergedResult
extends MemoryMergedResult {
    private static final Map<String, Integer> LABEL_AND_INDEX_MAP = new HashMap<String, Integer>(1, 1.0f);
    private final ShardingRule shardingRule;
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;
    private final Set<String> tableNames = new HashSet<String>();

    public ShowTablesMergedResult(ShardingRule shardingRule, List<QueryResult> queryResults) throws SQLException {
        super(LABEL_AND_INDEX_MAP);
        this.shardingRule = shardingRule;
        this.memoryResultSetRows = this.init(queryResults);
    }

    private Iterator<MemoryQueryResultRow> init(List<QueryResult> queryResults) throws SQLException {
        LinkedList<MemoryQueryResultRow> result = new LinkedList<MemoryQueryResultRow>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String actualTableName = memoryResultSetRow.getCell(1).toString();
                Optional<TableRule> tableRule = this.shardingRule.tryFindTableRuleByActualTable(actualTableName);
                if (!tableRule.isPresent()) {
                    result.add(memoryResultSetRow);
                    continue;
                }
                if (!this.tableNames.add(((TableRule)tableRule.get()).getLogicTable())) continue;
                memoryResultSetRow.setCell(1, ((TableRule)tableRule.get()).getLogicTable());
                result.add(memoryResultSetRow);
            }
        }
        if (!result.isEmpty()) {
            this.setCurrentResultSetRow((MemoryQueryResultRow)result.get(0));
        }
        return result.iterator();
    }

    @Override
    public boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.setCurrentResultSetRow(this.memoryResultSetRows.next());
            return true;
        }
        return false;
    }

    static {
        LABEL_AND_INDEX_MAP.put("Tables_in_sharding_db", 1);
    }
}

