/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingUnsupportedException;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.dal.describe.DescribeParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dal.show.ShowParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dal.use.UseParserFactory;
import io.shardingsphere.core.parsing.parser.sql.ddl.alter.AlterParserFactory;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.CreateParserFactory;
import io.shardingsphere.core.parsing.parser.sql.ddl.drop.DropParserFactory;
import io.shardingsphere.core.parsing.parser.sql.ddl.truncate.TruncateParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dml.delete.DeleteParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dml.update.UpdateParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectParserFactory;
import io.shardingsphere.core.parsing.parser.sql.tcl.TCLParserFactory;
import io.shardingsphere.core.rule.ShardingRule;

public final class SQLParserFactory {
    public static SQLParser newInstance(DatabaseType dbType, TokenType tokenType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingMetaData shardingMetaData) {
        if (SQLParserFactory.isDQL(tokenType)) {
            return SQLParserFactory.getDQLParser(dbType, shardingRule, lexerEngine, shardingMetaData);
        }
        if (SQLParserFactory.isDML(tokenType)) {
            return SQLParserFactory.getDMLParser(dbType, tokenType, shardingRule, lexerEngine, shardingMetaData);
        }
        if (SQLParserFactory.isDDL(tokenType)) {
            return SQLParserFactory.getDDLParser(dbType, tokenType, shardingRule, lexerEngine);
        }
        if (SQLParserFactory.isTCL(tokenType)) {
            return SQLParserFactory.getTCLParser(dbType, shardingRule, lexerEngine);
        }
        if (SQLParserFactory.isDAL(tokenType)) {
            return SQLParserFactory.getDALParser(dbType, (Keyword)tokenType, shardingRule, lexerEngine);
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private static boolean isDQL(TokenType tokenType) {
        return DefaultKeyword.SELECT == tokenType;
    }

    private static boolean isDML(TokenType tokenType) {
        return DefaultKeyword.INSERT == tokenType || DefaultKeyword.UPDATE == tokenType || DefaultKeyword.DELETE == tokenType;
    }

    private static boolean isDDL(TokenType tokenType) {
        return DefaultKeyword.CREATE == tokenType || DefaultKeyword.ALTER == tokenType || DefaultKeyword.DROP == tokenType || DefaultKeyword.TRUNCATE == tokenType;
    }

    private static boolean isTCL(TokenType tokenType) {
        return DefaultKeyword.SET == tokenType || DefaultKeyword.COMMIT == tokenType || DefaultKeyword.ROLLBACK == tokenType || DefaultKeyword.SAVEPOINT == tokenType || DefaultKeyword.BEGIN == tokenType;
    }

    private static boolean isDAL(TokenType tokenType) {
        return DefaultKeyword.USE == tokenType || DefaultKeyword.DESC == tokenType || MySQLKeyword.DESCRIBE == tokenType || MySQLKeyword.SHOW == tokenType;
    }

    private static SQLParser getDQLParser(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingMetaData shardingMetaData) {
        return SelectParserFactory.newInstance(dbType, shardingRule, lexerEngine, shardingMetaData);
    }

    private static SQLParser getDMLParser(DatabaseType dbType, TokenType tokenType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingMetaData shardingMetaData) {
        switch ((DefaultKeyword)tokenType) {
            case INSERT: {
                return InsertParserFactory.newInstance(dbType, shardingRule, lexerEngine, shardingMetaData);
            }
            case UPDATE: {
                return UpdateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DELETE: {
                return DeleteParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private static SQLParser getDDLParser(DatabaseType dbType, TokenType tokenType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch ((DefaultKeyword)tokenType) {
            case CREATE: {
                return CreateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case ALTER: {
                return AlterParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DROP: {
                return DropParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case TRUNCATE: {
                return TruncateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private static SQLParser getTCLParser(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        return TCLParserFactory.newInstance(dbType, shardingRule, lexerEngine);
    }

    private static SQLParser getDALParser(DatabaseType dbType, Keyword tokenType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        if (DefaultKeyword.USE == tokenType) {
            return UseParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        if (DefaultKeyword.DESC == tokenType || MySQLKeyword.DESCRIBE == tokenType) {
            return DescribeParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        if (MySQLKeyword.SHOW == tokenType) {
            return ShowParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private SQLParserFactory() {
    }
}

