/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rewrite;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.insert.InsertShardingCondition;
import io.shardingsphere.core.rewrite.placeholder.IndexPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.InsertValuesPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.SchemaPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.ShardingPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.TablePlaceholder;
import io.shardingsphere.core.routing.SQLUnit;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLBuilder {
    private final List<Object> segments = new LinkedList<Object>();
    private final List<Object> parameters;
    private StringBuilder currentSegment;

    public SQLBuilder() {
        this(Collections.emptyList());
    }

    public SQLBuilder(List<Object> parameters) {
        this.parameters = parameters;
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public void appendLiterals(String literals) {
        this.currentSegment.append(literals);
    }

    public void appendPlaceholder(ShardingPlaceholder shardingPlaceholder) {
        this.segments.add(shardingPlaceholder);
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public SQLUnit toSQL(TableUnit tableUnit, Map<String, String> logicAndActualTableMap, ShardingRule shardingRule) {
        LinkedList<Object> insertParameters = new LinkedList<Object>();
        StringBuilder result = new StringBuilder();
        for (Object each : this.segments) {
            if (!(each instanceof ShardingPlaceholder)) {
                result.append(each);
                continue;
            }
            String logicTableName = ((ShardingPlaceholder)each).getLogicTableName();
            String actualTableName = logicAndActualTableMap.get(logicTableName);
            if (each instanceof TablePlaceholder) {
                result.append(null == actualTableName ? logicTableName : actualTableName);
                continue;
            }
            if (each instanceof SchemaPlaceholder) {
                SchemaPlaceholder schemaPlaceholder = (SchemaPlaceholder)each;
                Optional<TableRule> tableRule = shardingRule.tryFindTableRuleByActualTable(actualTableName);
                if (!tableRule.isPresent() && Strings.isNullOrEmpty((String)shardingRule.getShardingDataSourceNames().getDefaultDataSourceName())) {
                    throw new ShardingException("Cannot found schema name '%s' in sharding rule.", schemaPlaceholder.getLogicSchemaName());
                }
                Preconditions.checkState((boolean)tableRule.isPresent());
                result.append(((TableRule)tableRule.get()).getActualDatasourceNames().iterator().next());
                continue;
            }
            if (each instanceof IndexPlaceholder) {
                IndexPlaceholder indexPlaceholder = (IndexPlaceholder)each;
                result.append(indexPlaceholder.getLogicIndexName());
                if (Strings.isNullOrEmpty((String)actualTableName)) continue;
                result.append("_");
                result.append(actualTableName);
                continue;
            }
            if (each instanceof InsertValuesPlaceholder) {
                InsertValuesPlaceholder insertValuesPlaceholder = (InsertValuesPlaceholder)each;
                LinkedList<String> expressions = new LinkedList<String>();
                for (ShardingCondition shardingCondition : insertValuesPlaceholder.getShardingConditions().getShardingConditions()) {
                    this.processInsertShardingCondition(tableUnit, (InsertShardingCondition)shardingCondition, expressions, insertParameters);
                }
                int count = 0;
                for (String s : expressions) {
                    if (0 != count) {
                        result.append(", ");
                    }
                    result.append(s);
                    ++count;
                }
                continue;
            }
            result.append(each);
        }
        if (insertParameters.isEmpty()) {
            return new SQLUnit(result.toString(), new ArrayList<List<Object>>(Collections.singleton(this.parameters)));
        }
        return new SQLUnit(result.toString(), new ArrayList<List<Object>>(Collections.singleton(insertParameters)));
    }

    private void processInsertShardingCondition(TableUnit tableUnit, InsertShardingCondition shardingCondition, List<String> expressions, List<Object> parameters) {
        for (DataNode dataNode : shardingCondition.getDataNodes()) {
            if (!dataNode.getDataSourceName().equals(tableUnit.getDataSourceName()) || !dataNode.getTableName().equals(tableUnit.getRoutingTables().iterator().next().getActualTableName())) continue;
            expressions.add(shardingCondition.getInsertValueExpression());
            parameters.addAll(shardingCondition.getParameters());
            break;
        }
    }
}

