/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.masterslave.ShardingMasterSlaveRouter;
import io.shardingsphere.core.routing.router.sharding.ShardingRouter;
import io.shardingsphere.core.routing.router.sharding.ShardingRouterFactory;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.Collections;

public final class StatementRoutingEngine {
    private final ShardingRouter shardingRouter;
    private final ShardingMasterSlaveRouter masterSlaveRouter;

    public StatementRoutingEngine(ShardingRule shardingRule, ShardingMetaData shardingMetaData, DatabaseType databaseType, boolean showSQL) {
        this.shardingRouter = ShardingRouterFactory.createSQLRouter(shardingRule, shardingMetaData, databaseType, showSQL);
        this.masterSlaveRouter = new ShardingMasterSlaveRouter(shardingRule.getMasterSlaveRules());
    }

    public SQLRouteResult route(String logicSQL) {
        SQLStatement sqlStatement = this.shardingRouter.parse(logicSQL, false);
        return this.masterSlaveRouter.route(this.shardingRouter.route(logicSQL, Collections.emptyList(), sqlStatement));
    }
}

