/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.yaml.masterslave;

import com.google.common.base.Strings;
import io.shardingsphere.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithm;
import io.shardingsphere.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmType;
import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.exception.ShardingConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class YamlMasterSlaveRuleConfiguration {
    private String name;
    private String masterDataSourceName;
    private Collection<String> slaveDataSourceNames = new ArrayList<String>();
    private MasterSlaveLoadBalanceAlgorithmType loadBalanceAlgorithmType;
    private String loadBalanceAlgorithmClassName;
    private Map<String, Object> configMap = new ConcurrentHashMap<String, Object>();

    public MasterSlaveRuleConfiguration getMasterSlaveRuleConfiguration() {
        MasterSlaveLoadBalanceAlgorithm loadBalanceAlgorithm = null;
        if (!Strings.isNullOrEmpty((String)this.loadBalanceAlgorithmClassName)) {
            loadBalanceAlgorithm = this.newInstance(this.loadBalanceAlgorithmClassName);
        } else if (null != this.loadBalanceAlgorithmType) {
            loadBalanceAlgorithm = this.loadBalanceAlgorithmType.getAlgorithm();
        }
        return new MasterSlaveRuleConfiguration(this.name, this.masterDataSourceName, this.slaveDataSourceNames, loadBalanceAlgorithm);
    }

    private MasterSlaveLoadBalanceAlgorithm newInstance(String masterSlaveLoadBalanceAlgorithmClassName) {
        try {
            Class<?> result = Class.forName(masterSlaveLoadBalanceAlgorithmClassName);
            if (!MasterSlaveLoadBalanceAlgorithm.class.isAssignableFrom(result)) {
                throw new ShardingConfigurationException("Class %s should be implement %s", masterSlaveLoadBalanceAlgorithmClassName, MasterSlaveLoadBalanceAlgorithm.class.getName());
            }
            return (MasterSlaveLoadBalanceAlgorithm)result.newInstance();
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingConfigurationException("Class %s should have public privilege and no argument constructor", masterSlaveLoadBalanceAlgorithmClassName);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public Collection<String> getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    public MasterSlaveLoadBalanceAlgorithmType getLoadBalanceAlgorithmType() {
        return this.loadBalanceAlgorithmType;
    }

    public String getLoadBalanceAlgorithmClassName() {
        return this.loadBalanceAlgorithmClassName;
    }

    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMasterDataSourceName(String masterDataSourceName) {
        this.masterDataSourceName = masterDataSourceName;
    }

    public void setSlaveDataSourceNames(Collection<String> slaveDataSourceNames) {
        this.slaveDataSourceNames = slaveDataSourceNames;
    }

    public void setLoadBalanceAlgorithmType(MasterSlaveLoadBalanceAlgorithmType loadBalanceAlgorithmType) {
        this.loadBalanceAlgorithmType = loadBalanceAlgorithmType;
    }

    public void setLoadBalanceAlgorithmClassName(String loadBalanceAlgorithmClassName) {
        this.loadBalanceAlgorithmClassName = loadBalanceAlgorithmClassName;
    }

    public void setConfigMap(Map<String, Object> configMap) {
        this.configMap = configMap;
    }
}

