/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.yaml.sharding;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.algorithm.sharding.complex.ComplexKeysShardingAlgorithm;
import io.shardingsphere.core.api.algorithm.sharding.hint.HintShardingAlgorithm;
import io.shardingsphere.core.api.algorithm.sharding.standard.PreciseShardingAlgorithm;
import io.shardingsphere.core.api.algorithm.sharding.standard.RangeShardingAlgorithm;
import io.shardingsphere.core.api.config.strategy.ComplexShardingStrategyConfiguration;
import io.shardingsphere.core.api.config.strategy.HintShardingStrategyConfiguration;
import io.shardingsphere.core.api.config.strategy.InlineShardingStrategyConfiguration;
import io.shardingsphere.core.api.config.strategy.NoneShardingStrategyConfiguration;
import io.shardingsphere.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingsphere.core.api.config.strategy.StandardShardingStrategyConfiguration;
import io.shardingsphere.core.routing.strategy.ShardingAlgorithmFactory;
import io.shardingsphere.core.yaml.sharding.strategy.YamlComplexShardingStrategyConfiguration;
import io.shardingsphere.core.yaml.sharding.strategy.YamlHintShardingStrategyConfiguration;
import io.shardingsphere.core.yaml.sharding.strategy.YamlInlineShardingStrategyConfiguration;
import io.shardingsphere.core.yaml.sharding.strategy.YamlNoneShardingStrategyConfiguration;
import io.shardingsphere.core.yaml.sharding.strategy.YamlStandardShardingStrategyConfiguration;

public class YamlShardingStrategyConfiguration {
    private YamlStandardShardingStrategyConfiguration standard;
    private YamlComplexShardingStrategyConfiguration complex;
    private YamlHintShardingStrategyConfiguration hint;
    private YamlInlineShardingStrategyConfiguration inline;
    private YamlNoneShardingStrategyConfiguration none;

    public ShardingStrategyConfiguration build() {
        int shardingStrategyConfigCount = 0;
        ShardingStrategyConfiguration result = null;
        if (null != this.standard) {
            ++shardingStrategyConfigCount;
            result = null == this.standard.getRangeAlgorithmClassName() ? new StandardShardingStrategyConfiguration(this.standard.getShardingColumn(), ShardingAlgorithmFactory.newInstance(this.standard.getPreciseAlgorithmClassName(), PreciseShardingAlgorithm.class)) : new StandardShardingStrategyConfiguration(this.standard.getShardingColumn(), ShardingAlgorithmFactory.newInstance(this.standard.getPreciseAlgorithmClassName(), PreciseShardingAlgorithm.class), ShardingAlgorithmFactory.newInstance(this.standard.getRangeAlgorithmClassName(), RangeShardingAlgorithm.class));
        }
        if (null != this.complex) {
            ++shardingStrategyConfigCount;
            result = new ComplexShardingStrategyConfiguration(this.complex.getShardingColumns(), ShardingAlgorithmFactory.newInstance(this.complex.getAlgorithmClassName(), ComplexKeysShardingAlgorithm.class));
        }
        if (null != this.inline) {
            ++shardingStrategyConfigCount;
            result = new InlineShardingStrategyConfiguration(this.inline.getShardingColumn(), this.inline.getAlgorithmExpression());
        }
        if (null != this.hint) {
            ++shardingStrategyConfigCount;
            result = new HintShardingStrategyConfiguration(ShardingAlgorithmFactory.newInstance(this.hint.getAlgorithmClassName(), HintShardingAlgorithm.class));
        }
        if (null != this.none) {
            ++shardingStrategyConfigCount;
            result = new NoneShardingStrategyConfiguration();
        }
        Preconditions.checkArgument((shardingStrategyConfigCount <= 1 ? 1 : 0) != 0, (Object)"Only allowed 0 or 1 sharding strategy configuration.");
        return result;
    }

    public YamlStandardShardingStrategyConfiguration getStandard() {
        return this.standard;
    }

    public YamlComplexShardingStrategyConfiguration getComplex() {
        return this.complex;
    }

    public YamlHintShardingStrategyConfiguration getHint() {
        return this.hint;
    }

    public YamlInlineShardingStrategyConfiguration getInline() {
        return this.inline;
    }

    public YamlNoneShardingStrategyConfiguration getNone() {
        return this.none;
    }

    public void setStandard(YamlStandardShardingStrategyConfiguration standard) {
        this.standard = standard;
    }

    public void setComplex(YamlComplexShardingStrategyConfiguration complex) {
        this.complex = complex;
    }

    public void setHint(YamlHintShardingStrategyConfiguration hint) {
        this.hint = hint;
    }

    public void setInline(YamlInlineShardingStrategyConfiguration inline) {
        this.inline = inline;
    }

    public void setNone(YamlNoneShardingStrategyConfiguration none) {
        this.none = none;
    }
}

