/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.support.DefaultQueryCountLogEntryCreator;
import net.ttddyy.dsproxy.support.QueryCountLogEntryCreator;

public abstract class AbstractQueryCountLoggingRequestListener
implements ServletRequestListener {
    private QueryCountLogEntryCreator logFormatter = new DefaultQueryCountLogEntryCreator();
    private boolean writeAsJson = false;

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount count = QueryCountHolder.get(dsName);
            String logEntry = this.writeAsJson ? this.logFormatter.getLogMessageAsJson(dsName, count) : this.logFormatter.getLogMessage(dsName, count);
            this.writeLog(sre, logEntry);
        }
        QueryCountHolder.clear();
    }

    protected abstract void writeLog(ServletRequestEvent var1, String var2);

    public void setLogFormatter(QueryCountLogEntryCreator logFormatter) {
        this.logFormatter = logFormatter;
    }

    public void setWriteAsJson(boolean writeAsJson) {
        this.writeAsJson = writeAsJson;
    }
}

