/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.artifact.ArtifactWithProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.StringSearchModelInterpolator;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class VersionExpressionTransformation
extends StringSearchModelInterpolator
implements Initializable,
ArtifactTransformation {
    /*
     * WARNING - void declaration
     */
    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        File pomFile;
        ProjectArtifactMetadata metadata = ArtifactWithProject.getProjectArtifactMetadata(artifact);
        boolean pomArtifact = false;
        if ("pom".equals(artifact.getType())) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("On Deploy: Using artifact file for POM: " + artifact);
            }
            pomFile = artifact.getFile();
            pomArtifact = true;
        } else if (metadata != null) {
            pomFile = metadata.getFile();
        } else {
            return;
        }
        try {
            void var5_6;
            File outFile = this.transformVersions((File)var5_6, artifact, localRepository);
            if (pomArtifact) {
                artifact.setFile(outFile);
            } else {
                metadata.setFile(outFile);
                metadata.setVersionExpressionsResolved(true);
            }
        }
        catch (IOException e) {
            throw new ArtifactDeploymentException("Failed to read or write POM for version transformation.", (Throwable)e);
        }
        catch (ModelInterpolationException e) {
            throw new ArtifactDeploymentException("Failed to interpolate POM versions.", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        File pomFile;
        ProjectArtifactMetadata metadata = (ProjectArtifactMetadata)artifact.getMetadata(ProjectArtifactMetadata.class);
        boolean pomArtifact = false;
        if ("pom".equals(artifact.getType())) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("On Install: Using artifact file for POM: " + artifact);
            }
            pomFile = artifact.getFile();
            pomArtifact = true;
        } else if (metadata != null) {
            pomFile = metadata.getFile();
        } else {
            return;
        }
        try {
            void var4_5;
            File outFile = this.transformVersions((File)var4_5, artifact, localRepository);
            if (pomArtifact) {
                artifact.setFile(outFile);
            } else {
                metadata.setFile(outFile);
                metadata.setVersionExpressionsResolved(true);
            }
        }
        catch (IOException e) {
            throw new ArtifactInstallationException("Failed to read or write POM for version transformation.", (Throwable)e);
        }
        catch (ModelInterpolationException e) {
            throw new ArtifactInstallationException("Failed to interpolate POM versions.", (Throwable)e);
        }
    }

    public void transformForResolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File transformVersions(File pomFile, Artifact artifact, ArtifactRepository localRepository) throws IOException, ModelInterpolationException {
        File outputFile;
        ProjectBuilderConfiguration pbConfig;
        File projectDir;
        if (artifact instanceof ArtifactWithProject) {
            MavenProject project = ((ArtifactWithProject)artifact).getProject();
            projectDir = project.getBasedir();
            pbConfig = project.getProjectBuilderConfiguration();
            outputFile = new File(project.getBuild().getDirectory(), "pom-transformed.xml");
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("WARNING: Artifact: " + artifact + " does not have project-builder metadata (ProjectBuilderConfiguration) associated with it.\n" + "Cannot access CLI properties for version transformation.");
            }
            pbConfig = new DefaultProjectBuilderConfiguration().setLocalRepository(localRepository);
            projectDir = pomFile.getAbsoluteFile().getParentFile();
            outputFile = new File(projectDir, "target/pom-transformed.xml");
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            Model model = new MavenXpp3Reader().read((Reader)reader);
            this.interpolateVersions(pomFile, outputFile, model, projectDir, pbConfig);
        }
        catch (XmlPullParserException e) {
            String message = "Failed to parse POM for version transformation. Proceeding with original (non-interpolated) POM file.";
            String detail = "\n\nNOTE: Error was in file: " + pomFile + ", at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message + detail, (Throwable)e);
            } else {
                this.getLogger().warn(message + " See debug output for details.");
            }
            outputFile = pomFile;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interpolateVersions(File pomFile, File outputFile, Model model, File projectDir, ProjectBuilderConfiguration config) throws ModelInterpolationException {
        boolean debugEnabled = this.getLogger().isDebugEnabled();
        StringSearchInterpolator interpolator = new StringSearchInterpolator("<version>", "</version>");
        Interpolator secondaryInterpolator = this.getInterpolator();
        RecursionInterceptor recursionInterceptor = this.getRecursionInterceptor();
        interpolator.addValueSource((ValueSource)new SecondaryInterpolationValueSource(secondaryInterpolator, recursionInterceptor));
        interpolator.addPostProcessor((InterpolationPostProcessor)new VersionRestoringPostProcessor());
        List valueSources = this.createValueSources(model, projectDir, config);
        List postProcessors = this.createPostProcessors(model, projectDir, config);
        VersionExpressionTransformation versionExpressionTransformation = this;
        synchronized (versionExpressionTransformation) {
            Iterator iterator2;
            String pomContents;
            Iterator it = valueSources.iterator();
            while (it.hasNext()) {
                ValueSource vs = (ValueSource)it.next();
                secondaryInterpolator.addValueSource(vs);
            }
            it = postProcessors.iterator();
            while (it.hasNext()) {
                InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)it.next();
                secondaryInterpolator.addPostProcessor(postProcessor);
            }
            try {
                List feedback;
                XmlStreamReader reader = null;
                try {
                    reader = ReaderFactory.newXmlReader((File)pomFile);
                    pomContents = IOUtil.toString((Reader)reader);
                }
                catch (IOException e) {
                    throw new ModelInterpolationException("Error reading POM for version-expression interpolation: " + e.getMessage(), e);
                }
                finally {
                    IOUtil.close((Reader)reader);
                }
                try {
                    pomContents = interpolator.interpolate(pomContents);
                }
                catch (InterpolationException e) {
                    throw new ModelInterpolationException(e.getMessage(), e);
                }
                if (debugEnabled && (feedback = interpolator.getFeedback()) != null && !feedback.isEmpty()) {
                    this.getLogger().debug("Maven encountered the following problems while transforming POM versions:");
                    Object last = null;
                    Iterator it2 = feedback.iterator();
                    while (it2.hasNext()) {
                        Object next = it2.next();
                        if (next instanceof Throwable) {
                            if (last == null) {
                                this.getLogger().debug("", (Throwable)next);
                                continue;
                            }
                            this.getLogger().debug(String.valueOf(last), (Throwable)next);
                            continue;
                        }
                        if (last != null) {
                            this.getLogger().debug(String.valueOf(last));
                        }
                        last = next;
                    }
                    if (last != null) {
                        this.getLogger().debug(String.valueOf(last));
                    }
                }
                interpolator.clearFeedback();
                Object var20_23 = null;
                iterator2 = valueSources.iterator();
            }
            catch (Throwable throwable) {
                Object var20_24 = null;
                Iterator iterator2 = valueSources.iterator();
                while (iterator2.hasNext()) {
                    ValueSource vs = (ValueSource)iterator2.next();
                    secondaryInterpolator.removeValuesSource(vs);
                }
                iterator2 = postProcessors.iterator();
                while (iterator2.hasNext()) {
                    InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)iterator2.next();
                    secondaryInterpolator.removePostProcessor(postProcessor);
                }
                this.getInterpolator().clearAnswers();
                throw throwable;
            }
            while (iterator2.hasNext()) {
                ValueSource vs = (ValueSource)iterator2.next();
                secondaryInterpolator.removeValuesSource(vs);
            }
            iterator2 = postProcessors.iterator();
            while (iterator2.hasNext()) {
                InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)iterator2.next();
                secondaryInterpolator.removePostProcessor(postProcessor);
            }
            {
            }
            this.getInterpolator().clearAnswers();
            XmlStreamWriter writer = null;
            try {
                outputFile.getParentFile().mkdirs();
                writer = WriterFactory.newXmlWriter((File)outputFile);
                IOUtil.copy((String)pomContents, (Writer)writer);
            }
            catch (IOException e) {
                try {
                    throw new ModelInterpolationException("Failed to write transformed POM: " + outputFile.getAbsolutePath(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
        }
    }

    private static final class VersionRestoringPostProcessor
    implements InterpolationPostProcessor {
        private VersionRestoringPostProcessor() {
        }

        public Object execute(String expression, Object value) {
            return "<version>" + value + "</version>";
        }
    }

    private static final class SecondaryInterpolationValueSource
    implements ValueSource {
        private Interpolator secondary;
        private final RecursionInterceptor recursionInterceptor;
        private List localFeedback = new ArrayList();

        public SecondaryInterpolationValueSource(Interpolator secondary, RecursionInterceptor recursionInterceptor) {
            this.secondary = secondary;
            this.recursionInterceptor = recursionInterceptor;
        }

        public void clearFeedback() {
            this.secondary.clearFeedback();
        }

        public List getFeedback() {
            ArrayList result = this.secondary.getFeedback();
            if (result != null) {
                result = new ArrayList(result);
            }
            result.addAll(this.localFeedback);
            return result;
        }

        public Object getValue(String expression) {
            try {
                return this.secondary.interpolate(expression, this.recursionInterceptor);
            }
            catch (InterpolationException e) {
                this.localFeedback.add("Error during version expression interpolation.");
                this.localFeedback.add(e);
                return null;
            }
        }
    }
}

