/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.openqa.selenium.net.EphemeralPortRangeDetector;
import org.openqa.selenium.net.FixedIANAPortRange;

public class LinuxEphemeralPortRangeDetector
implements EphemeralPortRangeDetector {
    private final int firstEphemeralPort;
    private final int lastEphemeralPort;

    public static LinuxEphemeralPortRangeDetector getInstance() {
        File file = new File("/proc/sys/net/ipv4/ip_local_port_range");
        if (file.exists() && file.canRead()) {
            LinuxEphemeralPortRangeDetector linuxEphemeralPortRangeDetector;
            FileReader inputFil = new FileReader(file);
            try {
                linuxEphemeralPortRangeDetector = new LinuxEphemeralPortRangeDetector(inputFil);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)inputFil).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ((Reader)inputFil).close();
            return linuxEphemeralPortRangeDetector;
        }
        return new LinuxEphemeralPortRangeDetector(new StringReader("49152 65535"));
    }

    LinuxEphemeralPortRangeDetector(Reader inputFil) {
        FixedIANAPortRange defaultRange = new FixedIANAPortRange();
        int lowPort = defaultRange.getLowestEphemeralPort();
        int highPort = defaultRange.getHighestEphemeralPort();
        try (BufferedReader in = new BufferedReader(inputFil);){
            String[] split = in.readLine().split("\\s+");
            lowPort = Integer.parseInt(split[0]);
            highPort = Integer.parseInt(split[1]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.firstEphemeralPort = lowPort;
        this.lastEphemeralPort = highPort;
    }

    @Override
    public int getLowestEphemeralPort() {
        return this.firstEphemeralPort;
    }

    @Override
    public int getHighestEphemeralPort() {
        return this.lastEphemeralPort;
    }
}

