/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.browser;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.browser.model.Bounds;
import org.openqa.selenium.devtools.browser.model.Histogram;
import org.openqa.selenium.devtools.browser.model.PermissionDescriptor;
import org.openqa.selenium.devtools.browser.model.PermissionSetting;
import org.openqa.selenium.devtools.browser.model.PermissionType;
import org.openqa.selenium.devtools.browser.model.WindowID;
import org.openqa.selenium.devtools.target.model.BrowserContextID;
import org.openqa.selenium.devtools.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class Browser {
    @Beta
    public static Command<Void> setPermission(String origin, PermissionDescriptor permission, PermissionSetting setting, Optional<TargetID> browserContextId) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(permission, "permission is required");
        Objects.requireNonNull(setting, "setting is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        params.put((Object)"permission", (Object)permission);
        params.put((Object)"setting", (Object)setting);
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command<Void>("Browser.setPermission", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> grantPermissions(String origin, List<PermissionType> permissions, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(permissions, "permissions is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        params.put((Object)"permissions", permissions);
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command<Void>("Browser.grantPermissions", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> resetPermissions(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command<Void>("Browser.resetPermissions", (Map<String, Object>)params.build());
    }

    public static Command<Void> close() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Browser.close", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> crash() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Browser.crash", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> crashGpuProcess() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Browser.crashGpuProcess", (Map<String, Object>)params.build());
    }

    public static Command<GetVersionResponse> getVersion() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<GetVersionResponse>("Browser.getVersion", (Map<String, Object>)params.build(), input -> (GetVersionResponse)input.read(GetVersionResponse.class));
    }

    @Beta
    public static Command<List<String>> getBrowserCommandLine() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<String>>("Browser.getBrowserCommandLine", (Map<String, Object>)params.build(), ConverterFunctions.map("arguments", new TypeToken<List<String>>(){}.getType()));
    }

    @Beta
    public static Command<List<Histogram>> getHistograms(Optional<String> query, Optional<Boolean> delta) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        query.ifPresent(p -> params.put((Object)"query", p));
        delta.ifPresent(p -> params.put((Object)"delta", p));
        return new Command<List<Histogram>>("Browser.getHistograms", (Map<String, Object>)params.build(), ConverterFunctions.map("histograms", new TypeToken<List<Histogram>>(){}.getType()));
    }

    @Beta
    public static Command<Histogram> getHistogram(String name, Optional<Boolean> delta) {
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"name", (Object)name);
        delta.ifPresent(p -> params.put((Object)"delta", p));
        return new Command<Histogram>("Browser.getHistogram", (Map<String, Object>)params.build(), ConverterFunctions.map("histogram", Histogram.class));
    }

    @Beta
    public static Command<Bounds> getWindowBounds(WindowID windowId) {
        Objects.requireNonNull(windowId, "windowId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"windowId", (Object)windowId);
        return new Command<Bounds>("Browser.getWindowBounds", (Map<String, Object>)params.build(), ConverterFunctions.map("bounds", Bounds.class));
    }

    @Beta
    public static Command<GetWindowForTargetResponse> getWindowForTarget(Optional<TargetID> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        targetId.ifPresent(p -> params.put((Object)"targetId", p));
        return new Command<GetWindowForTargetResponse>("Browser.getWindowForTarget", (Map<String, Object>)params.build(), input -> (GetWindowForTargetResponse)input.read(GetWindowForTargetResponse.class));
    }

    @Beta
    public static Command<Void> setWindowBounds(WindowID windowId, Bounds bounds) {
        Objects.requireNonNull(windowId, "windowId is required");
        Objects.requireNonNull(bounds, "bounds is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"windowId", (Object)windowId);
        params.put((Object)"bounds", (Object)bounds);
        return new Command<Void>("Browser.setWindowBounds", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> setDockTile(Optional<String> badgeLabel, Optional<String> image) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        badgeLabel.ifPresent(p -> params.put((Object)"badgeLabel", p));
        image.ifPresent(p -> params.put((Object)"image", p));
        return new Command<Void>("Browser.setDockTile", (Map<String, Object>)params.build());
    }

    public static class GetWindowForTargetResponse {
        private final WindowID windowId;
        private final Bounds bounds;

        public GetWindowForTargetResponse(WindowID windowId, Bounds bounds) {
            this.windowId = Objects.requireNonNull(windowId, "windowId is required");
            this.bounds = Objects.requireNonNull(bounds, "bounds is required");
        }

        public WindowID getWindowId() {
            return this.windowId;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        private static GetWindowForTargetResponse fromJson(JsonInput input) {
            WindowID windowId = null;
            Bounds bounds = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "windowId": {
                        windowId = (WindowID)input.read(WindowID.class);
                        continue block8;
                    }
                    case "bounds": {
                        bounds = (Bounds)input.read(Bounds.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetWindowForTargetResponse(windowId, bounds);
        }
    }

    public static class GetVersionResponse {
        private final String protocolVersion;
        private final String product;
        private final String revision;
        private final String userAgent;
        private final String jsVersion;

        public GetVersionResponse(String protocolVersion, String product, String revision, String userAgent, String jsVersion) {
            this.protocolVersion = Objects.requireNonNull(protocolVersion, "protocolVersion is required");
            this.product = Objects.requireNonNull(product, "product is required");
            this.revision = Objects.requireNonNull(revision, "revision is required");
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent is required");
            this.jsVersion = Objects.requireNonNull(jsVersion, "jsVersion is required");
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        public String getProduct() {
            return this.product;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getJsVersion() {
            return this.jsVersion;
        }

        private static GetVersionResponse fromJson(JsonInput input) {
            String protocolVersion = null;
            String product = null;
            String revision = null;
            String userAgent = null;
            String jsVersion = null;
            input.beginObject();
            block14: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "protocolVersion": {
                        protocolVersion = input.nextString();
                        continue block14;
                    }
                    case "product": {
                        product = input.nextString();
                        continue block14;
                    }
                    case "revision": {
                        revision = input.nextString();
                        continue block14;
                    }
                    case "userAgent": {
                        userAgent = input.nextString();
                        continue block14;
                    }
                    case "jsVersion": {
                        jsVersion = input.nextString();
                        continue block14;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetVersionResponse(protocolVersion, product, revision, userAgent, jsVersion);
        }
    }
}

