/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.dom.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum PseudoType {
    FIRST_LINE("first-line"),
    FIRST_LETTER("first-letter"),
    BEFORE("before"),
    AFTER("after"),
    BACKDROP("backdrop"),
    SELECTION("selection"),
    FIRST_LINE_INHERITED("first-line-inherited"),
    SCROLLBAR("scrollbar"),
    SCROLLBAR_THUMB("scrollbar-thumb"),
    SCROLLBAR_BUTTON("scrollbar-button"),
    SCROLLBAR_TRACK("scrollbar-track"),
    SCROLLBAR_TRACK_PIECE("scrollbar-track-piece"),
    SCROLLBAR_CORNER("scrollbar-corner"),
    RESIZER("resizer"),
    INPUT_LIST_BUTTON("input-list-button");

    private String value;

    private PseudoType(String value) {
        this.value = value;
    }

    public static PseudoType fromString(String s) {
        return Arrays.stream(PseudoType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PseudoType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PseudoType fromJson(JsonInput input) {
        return PseudoType.fromString(input.nextString());
    }
}

